/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.container;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.common.DsfVerifierConfig;
import org.eclipse.vjet.dsf.common.container.IDsfNodeInstantiationValidator;
import org.eclipse.vjet.dsf.common.container.IDsfNodeProvider;
import org.eclipse.vjet.dsf.common.container.NoOpDsfNodeProvider;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.naming.DefaultDsfNamingFamily;
import org.eclipse.vjet.dsf.common.naming.HtmlIdNamingFamily;
import org.eclipse.vjet.dsf.common.naming.IDsfNamingFamily;
import org.eclipse.vjet.dsf.common.node.DefaultDNodeRelationshipVerifier;
import org.eclipse.vjet.dsf.common.node.IDNodeRelationshipVerifier;
import org.eclipse.vjet.dsf.dom.DNode;

public final class DsfNodeContainer {
    private IDsfNodeProvider m_nodeProvider = NoOpDsfNodeProvider.getInstance();
    private IDsfNamingFamily m_namingFamily = HtmlIdNamingFamily.getInstance();
    private IDNodeRelationshipVerifier m_relationshipVerifier = DefaultDNodeRelationshipVerifier.getInstance();
    private List<IDsfNodeInstantiationValidator> m_nodeInstantiationValidators = new ArrayList<IDsfNodeInstantiationValidator>();
    private static final DsfVerifierConfig s_dsfVerifierConfig = DsfVerifierConfig.getInstance();

    public DsfNodeContainer() {
    }

    public DsfNodeContainer(IDsfNodeProvider nodeProvider, IDsfNamingFamily namingFamily, IDNodeRelationshipVerifier relationshipVerifier) {
        if (nodeProvider != null) {
            this.setNodeProvider(nodeProvider);
        }
        if (namingFamily != null) {
            this.setDsfNamingFamily(namingFamily);
        }
        if (relationshipVerifier != null) {
            this.setNodeRelationshipVerifier(relationshipVerifier);
        }
    }

    public IDsfNodeProvider getNodeProvider() {
        return this.m_nodeProvider;
    }

    public void setNodeProvider(IDsfNodeProvider provider) {
        if (provider == null) {
            this.chuck("Node provider can't be null");
        }
        this.m_nodeProvider = provider;
    }

    public IDsfNamingFamily getDsfNamingFamily() {
        return this.m_namingFamily;
    }

    public void setDsfNamingFamily(IDsfNamingFamily namingFamily) {
        if (namingFamily == null) {
            this.chuck("DsfNamingFamily can't be null");
        }
        this.m_namingFamily = namingFamily;
    }

    public IDNodeRelationshipVerifier getNodeRelationshipVerifier() {
        return this.m_relationshipVerifier;
    }

    public void setNodeRelationshipVerifier(IDNodeRelationshipVerifier relationshipVerifier) {
        if (relationshipVerifier == null) {
            this.chuck("ComponentRelationshipVerifier must not be null");
        }
        this.m_relationshipVerifier = relationshipVerifier;
    }

    public boolean addNodeInstantiationValidator(IDsfNodeInstantiationValidator validator) {
        if (validator == null) {
            this.chuck("Validator must not be null");
        }
        if (!this.m_nodeInstantiationValidators.contains(validator)) {
            return this.m_nodeInstantiationValidators.add(validator);
        }
        return false;
    }

    public boolean removeNodeInstantiationValidator(IDsfNodeInstantiationValidator validator) {
        return this.m_nodeInstantiationValidators.remove(validator);
    }

    public void checkNodeInstantiation(DNode node) {
        if (node == null) {
            this.chuck("Node to have its instantiation checked must not be null");
        }
        if (!s_dsfVerifierConfig.isVerifyInstantiation()) {
            return;
        }
        int size = this.m_nodeInstantiationValidators.size();
        int i = 0;
        while (i < size) {
            this.m_nodeInstantiationValidators.get(i).validate(node);
            ++i;
        }
    }

    public void reset() {
        this.m_nodeProvider = NoOpDsfNodeProvider.getInstance();
        this.m_namingFamily = DefaultDsfNamingFamily.getInstance();
        this.m_relationshipVerifier = DefaultDNodeRelationshipVerifier.getInstance();
        this.m_nodeInstantiationValidators.clear();
    }

    protected void chuck(String message) {
        throw new DsfRuntimeException(message);
    }
}

