/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.serializer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.vjet.dsf.json.JsonArray;
import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.serializer.VjoSerializationCtx;
import org.eclipse.vjet.dsf.serializer.VjoSerializedCache;

public class VjoSerializedResult
extends JsonObject {
    private String m_vjoId;
    private String m_vjoType;
    private Map<VjoSerializedCache, String> m_brokenReferences;

    public String getVjoId() {
        return this.m_vjoId;
    }

    public VjoSerializedResult setVjoId(String id) {
        this.m_vjoId = id;
        return this;
    }

    public String getVjoType() {
        return this.m_vjoType;
    }

    public VjoSerializedResult setVjoType(String type) {
        this.m_vjoType = type;
        return this;
    }

    public Map<VjoSerializedCache, String> getBrokenReferences() {
        if (this.m_brokenReferences == null) {
            this.m_brokenReferences = new HashMap<VjoSerializedCache, String>();
        }
        return Collections.unmodifiableMap(this.m_brokenReferences);
    }

    public VjoSerializedResult addBrokenReference(VjoSerializedCache ref, String prop) {
        if (this.m_brokenReferences == null) {
            this.m_brokenReferences = new HashMap<VjoSerializedCache, String>();
        }
        this.m_brokenReferences.put(ref, prop);
        return this;
    }

    public String toString() {
        return this.append(new StringBuilder()).toString();
    }

    public StringBuilder append(StringBuilder sb) {
        return this.toWrapperString(sb);
    }

    public String toWrapperString() {
        return this.toWrapperString(new StringBuilder()).toString();
    }

    public String toWrapperString(String registryScope) {
        return this.toWrapperString(registryScope, new StringBuilder()).toString();
    }

    public StringBuilder toWrapperString(StringBuilder sb) {
        return this.toWrapperString(VjoSerializationCtx.ctx().getRegistryScope(), sb);
    }

    protected StringBuilder toBeginJson(StringBuilder sb) {
        sb.append("vjo.obj(");
        VjoSerializedResult.appendQuoted((String)this.getVjoType(), (StringBuilder)sb);
        sb.append(',');
        return sb;
    }

    protected StringBuilder toJsonData(StringBuilder sb) {
        return super.append(sb);
    }

    protected StringBuilder toEndJson(StringBuilder sb) {
        sb.append(')');
        return sb;
    }

    protected StringBuilder toBackReferences(StringBuilder sb) {
        Iterator<Map.Entry<VjoSerializedCache, String>> it = this.getBrokenReferences().entrySet().iterator();
        if (it.hasNext()) {
            sb.append(", {");
            do {
                Map.Entry<VjoSerializedCache, String> entry = it.next();
                VjoSerializedResult.appendQuoted((String)entry.getKey().getCacheId(), (StringBuilder)sb);
                sb.append(':');
                VjoSerializedResult.appendQuoted((String)entry.getValue(), (StringBuilder)sb);
                if (!it.hasNext()) continue;
                sb.append(',');
            } while (it.hasNext());
            sb.append('}');
        }
        return sb;
    }

    public StringBuilder toWrapperString(String registryScope, StringBuilder sb) {
        VjoSerializationCtx.ctx().setRegistryScope(registryScope);
        sb.append(registryScope);
        sb.append(".put(");
        VjoSerializedResult.appendQuoted((String)this.getVjoId(), (StringBuilder)sb);
        sb.append(',');
        this.toBeginJson(sb);
        this.toJsonData(sb);
        this.toEndJson(sb);
        this.toBackReferences(sb);
        sb.append(')');
        return sb;
    }

    public static String valueToString(Object value) {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (Character.TYPE.isAssignableFrom(value.getClass()) || Character.class.isAssignableFrom(value.getClass())) {
            return VjoSerializedResult.quote((String)value.toString());
        }
        if (value instanceof Number) {
            return VjoSerializedResult.numberToString((Number)((Number)value));
        }
        if (value instanceof Boolean || value instanceof JsonArray || JsonObject.class.isAssignableFrom(value.getClass())) {
            return value.toString();
        }
        if (!(value instanceof String)) {
            return value.toString();
        }
        return VjoSerializedResult.quote((String)value.toString());
    }
}

