/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.resource.pattern.js;

import java.net.URL;
import org.eclipse.vjet.dsf.common.CallerIntrospector;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.resource.pattern.BaseResource;
import org.eclipse.vjet.dsf.resource.permutation.Permutation;
import org.eclipse.vjet.dsf.resource.trace.ResourceUsageCtx;
import org.eclipse.vjet.dsf.resource.utils.ResourceUtil;
import org.eclipse.vjet.dsf.resource.x.IResourceAggregationModeResolver;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceHandle;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResRtCfg;
import org.eclipse.vjet.vsf.resource.pattern.js.resolution.DefaultJsResourceHandle;
import org.eclipse.vjet.vsf.resource.pattern.js.resolution.DefaultJsResourceKey;

public class JsResource
extends BaseResource {
    private IHandleProvider m_handleProvider;
    private String m_resourceGroupId;

    public JsResource(Class<?> anchorClz, String resourceName, String urn, IHandleProvider handleProvider, String resourceGroupId) {
        super(anchorClz, resourceName, urn);
        assert (handleProvider != null) : "handleProvider must not be null";
        this.m_resourceGroupId = resourceGroupId;
        this.m_handleProvider = handleProvider;
        if (this.m_handleProvider instanceof DefaultHandleProvider) {
            ((DefaultHandleProvider)this.m_handleProvider).m_ref = this;
        }
    }

    protected JsResource() {
    }

    IJsResourceHandle getHandle(Permutation permutationCtx) {
        return this.m_handleProvider.getHandle(permutationCtx);
    }

    public String getResourceGroupId() {
        return this.m_resourceGroupId;
    }

    public IHandleProvider getHandleProvider() {
        return this.m_handleProvider;
    }

    public void setHandleProvider(IHandleProvider handleProvider) {
        this.m_handleProvider = handleProvider;
    }

    public static JsResource viaName(String resourceName) {
        return JsResource.viaName(resourceName, CallerIntrospector.getCallingClass(), null);
    }

    public static JsResource viaName(String resourceName, String resourceGroupId) {
        return JsResource.viaName(resourceName, CallerIntrospector.getCallingClass(), resourceGroupId);
    }

    public static JsResource viaName(String resourceName, Class<?> anchorClass) {
        return JsResource.viaName(resourceName, anchorClass, null);
    }

    public static JsResource viaName(String resourceName, Class<?> anchorClass, String urn, String resourceGroupId) {
        return new JsResource(anchorClass, resourceName, urn, new DefaultHandleProvider(), resourceGroupId);
    }

    public static JsResource viaName(String resourceName, Class<?> anchorClass, String resourceGroupId) {
        return new JsResource(anchorClass, resourceName, null, new DefaultHandleProvider(), resourceGroupId);
    }

    public static JsResource via(String resourceName) {
        return JsResource.via(resourceName, null);
    }

    public static JsResource via(String resourceName, String resourceGroupId) {
        return new JsResource(CallerIntrospector.getCallingClass(), resourceName, null, new DefaultHandleProvider(), resourceGroupId);
    }

    public static JsResource viaUrl(URL externalUrl, String urn) {
        return new JsResource(CallerIntrospector.getCallingClass(), externalUrl.toExternalForm(), urn, new UrlOnlyHandleAdapter(externalUrl), null);
    }

    public static JsResource viaUrl(URL externalUrl, URL secureUrl, String urn) {
        return new JsResource(CallerIntrospector.getCallingClass(), externalUrl.toExternalForm(), urn, new UrlOnlyHandleAdapter(externalUrl, secureUrl, null, null), null);
    }

    public static JsResource viaRepoUrl(URL repoUrl, IHandleProvider proxiedHandle, String urn) {
        return new JsResource(CallerIntrospector.getCallingClass(), repoUrl.toExternalForm(), urn, new RepoUrlOnlyHandleAdapter(repoUrl, proxiedHandle), null);
    }

    public static JsResource viaRepoUrl(URL repoUrl, URL repoSecureUrl, IHandleProvider proxiedHandle, String urn) {
        return new JsResource(CallerIntrospector.getCallingClass(), repoUrl.toExternalForm(), urn, new RepoUrlOnlyHandleAdapter(repoUrl, repoSecureUrl, proxiedHandle), null);
    }

    public static JsResource viaOptimizedUrl(URL optimizedUrl, URL externalUrl, String urn) {
        return new JsResource(CallerIntrospector.getCallingClass(), externalUrl.toExternalForm(), urn, new OptimizedUrlOnlyHandleAdapter(optimizedUrl, new UrlOnlyHandleAdapter(externalUrl)), null);
    }

    public static JsResource viaOptimizedUrl(URL optimizedUrl, URL optimizedSecureUrl, URL externalUrl, URL secureUrl, String urn) {
        return new JsResource(CallerIntrospector.getCallingClass(), externalUrl.toExternalForm(), urn, new OptimizedUrlOnlyHandleAdapter(optimizedUrl, optimizedSecureUrl, (IHandleProvider)new UrlOnlyHandleAdapter(externalUrl, secureUrl, null, null)), null);
    }

    public static JsResource viaText(String jsText, String urn) {
        return new JsResource(CallerIntrospector.getCallingClass(), "GEN_" + jsText.length() + "_" + jsText.hashCode(), urn, new TextOnlyHandleAdapter(jsText), null);
    }

    public static JsResource viaText(String jsText, String urn, boolean minimize) {
        return new JsResource(CallerIntrospector.getCallingClass(), "GEN_" + jsText.length() + "_" + jsText.hashCode(), urn, new TextOnlyHandleAdapter(jsText, minimize), null);
    }

    public static JsResource viaJavaType(String typeName) {
        return new JsResource(CallerIntrospector.getCallingClass(), typeName, typeName, new DapOnlyHandleAdapter(String.valueOf(typeName) + "=Packages." + typeName + ";"), null);
    }

    public static JsResource viaJavaType(Class<?> type) {
        String typeName = type.getName();
        return new JsResource(CallerIntrospector.getCallingClass(), typeName, typeName, new DapOnlyHandleAdapter(String.valueOf(typeName) + "=Packages." + typeName + ";"), null);
    }

    public boolean isTextOnlyadapter() {
        return this.m_handleProvider instanceof TextOnlyHandleAdapter;
    }

    public void enableJava(String javaClassName) {
        this.m_handleProvider = new DapEnabledHandleProvider("vjo.ctype('" + javaClassName + "').endType(); " + javaClassName + "=Packages." + javaClassName + ";", this.m_handleProvider);
    }

    private static class DapEnabledHandleProvider
    implements IHandleProvider,
    IJsResourceHandle {
        private final String m_text;
        private final IHandleProvider m_defaultProvider;

        private DapEnabledHandleProvider(String text, IHandleProvider defaultProvider) {
            this.m_text = text;
            this.m_defaultProvider = defaultProvider;
        }

        @Override
        public IJsResourceHandle getHandle(Permutation permutationCtx) {
            if (DapCtx.ctx().getExeMode() != DapCtx.ExeMode.ACTIVE) {
                return this.m_defaultProvider.getHandle(permutationCtx);
            }
            return this;
        }

        @Override
        public URL getExternalUrl() {
            return null;
        }

        @Override
        public boolean isExternalized() {
            return false;
        }

        @Override
        public String getScriptText() {
            return this.m_text;
        }
    }

    private static class DapOnlyHandleAdapter
    implements IHandleProvider,
    IJsResourceHandle {
        private final String m_text;

        private DapOnlyHandleAdapter(String text) {
            this.m_text = text;
        }

        @Override
        public IJsResourceHandle getHandle(Permutation permutationCtx) {
            return this;
        }

        @Override
        public URL getExternalUrl() {
            return null;
        }

        @Override
        public boolean isExternalized() {
            return false;
        }

        @Override
        public String getScriptText() {
            if (DapCtx.ctx().getExeMode() != DapCtx.ExeMode.ACTIVE) {
                return "";
            }
            return this.m_text;
        }
    }

    public static class DefaultHandleProvider
    implements IHandleProvider {
        private JsResource m_ref;

        public IJsResourceHandle getHandle() {
            return this.getHandle(Permutation.getFromCtx());
        }

        @Override
        public IJsResourceHandle getHandle(Permutation permutationCtx) {
            return new DefaultJsResourceHandle(new DefaultJsResourceKey(this.m_ref.getAnchorClass(), this.m_ref.getResourceName(), permutationCtx, this.m_ref.getResourceGroupId()));
        }
    }

    public static interface IHandleProvider {
        public IJsResourceHandle getHandle(Permutation var1);
    }

    private static class OptimizedUrlOnlyHandleAdapter
    extends UrlOnlyHandleAdapter {
        private IHandleProvider m_proxiedHandle;

        private OptimizedUrlOnlyHandleAdapter(URL url, IHandleProvider proxiedHandle) {
            super(url, url);
            this.m_proxiedHandle = proxiedHandle;
        }

        private OptimizedUrlOnlyHandleAdapter(URL url, URL secureUrl, IHandleProvider proxiedHandle) {
            super(url, secureUrl);
            this.m_proxiedHandle = proxiedHandle;
        }

        @Override
        public IJsResourceHandle getHandle(Permutation permutationCtx) {
            if (ResourceUsageCtx.ctx().isUseOptimizedExternalPaths()) {
                return this;
            }
            return this.m_proxiedHandle.getHandle(permutationCtx);
        }
    }

    private static class RepoUrlOnlyHandleAdapter
    implements IHandleProvider,
    IJsResourceHandle {
        private URL m_url;
        private URL m_secureUrl;
        private IHandleProvider m_proxiedHandle;

        private RepoUrlOnlyHandleAdapter(URL url, IHandleProvider proxiedHandle) {
            this(url, url, proxiedHandle);
        }

        private RepoUrlOnlyHandleAdapter(URL url, URL secureUrl, IHandleProvider proxiedHandle) {
            this.m_url = url;
            this.m_secureUrl = secureUrl != null ? secureUrl : url;
            this.m_proxiedHandle = proxiedHandle;
        }

        @Override
        public IJsResourceHandle getHandle(Permutation permutationCtx) {
            IResourceAggregationModeResolver.AggregationMode mode = JsResRtCfg.getInstance().getAggregationMode();
            if (mode == IResourceAggregationModeResolver.AggregationMode.RUNTIME || mode == IResourceAggregationModeResolver.AggregationMode.TRANSITION || mode == IResourceAggregationModeResolver.AggregationMode.DYNAMIC) {
                return this;
            }
            return this.m_proxiedHandle.getHandle(permutationCtx);
        }

        @Override
        public URL getExternalUrl() {
            URL resultUrl = DsfCtx.ctx().isSecureRequest() ? this.m_secureUrl : this.m_url;
            resultUrl = ResourceUtil.modify((URL)resultUrl, (IResourceAggregationModeResolver.AggregationMode)JsResRtCfg.getInstance().getAggregationMode());
            return resultUrl;
        }

        @Override
        public boolean isExternalized() {
            return true;
        }

        @Override
        public String getScriptText() {
            return null;
        }
    }

    private static class TextOnlyHandleAdapter
    implements IHandleProvider,
    IJsResourceHandle {
        private final String m_text;

        private TextOnlyHandleAdapter(String text) {
            this.m_text = text;
        }

        private TextOnlyHandleAdapter(String text, boolean minimize) {
            this.m_text = text;
        }

        @Override
        public IJsResourceHandle getHandle(Permutation permutationCtx) {
            return this;
        }

        public IJsResourceHandle getHandle() {
            return this;
        }

        @Override
        public URL getExternalUrl() {
            return null;
        }

        @Override
        public boolean isExternalized() {
            return false;
        }

        @Override
        public String getScriptText() {
            return this.m_text;
        }
    }

    private static class UrlOnlyHandleAdapter
    implements IHandleProvider,
    IJsResourceHandle {
        private URL m_url;
        private URL m_secureUrl;

        private UrlOnlyHandleAdapter(URL url) {
            this.m_url = url;
            this.m_secureUrl = url;
        }

        private UrlOnlyHandleAdapter(URL url, URL secureUrl) {
            this.m_url = url;
            this.m_secureUrl = secureUrl;
        }

        @Override
        public IJsResourceHandle getHandle(Permutation permutationCtx) {
            return this;
        }

        @Override
        public URL getExternalUrl() {
            if (DsfCtx.ctx().isSecureRequest()) {
                return this.m_secureUrl;
            }
            return this.m_url;
        }

        @Override
        public boolean isExternalized() {
            return true;
        }

        @Override
        public String getScriptText() {
            return null;
        }

        /* synthetic */ UrlOnlyHandleAdapter(URL uRL, URL uRL2, UrlOnlyHandleAdapter urlOnlyHandleAdapter, UrlOnlyHandleAdapter urlOnlyHandleAdapter2) {
            this(uRL, uRL2);
        }
    }
}

