/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dervlet.defaultdervs;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.resource.permutation.Permutation;
import org.eclipse.vjet.vsf.dervlet.CoreDervlet;
import org.eclipse.vjet.vsf.dervlet.DsfDervlet;
import org.eclipse.vjet.vsf.dervlet.embedded.server.EmbeddedServer;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceHandle;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResource;

public class JsDervlet
extends DsfDervlet {
    private IJsResourceHandle m_jsHandle;

    public JsDervlet(String name, String path, IJsResourceHandle jsHandle) {
        super(name, path);
        this.m_jsHandle = jsHandle;
    }

    @Override
    protected void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream os = response.getOutputStream();
        String text = this.m_jsHandle.getScriptText();
        os.write(text.getBytes());
        os.close();
    }

    public static class JsResourceHandle
    implements IJsResourceHandle {
        private URL m_url;

        public JsResourceHandle(URL url) {
            this.m_url = url;
        }

        public URL getExternalUrl() {
            return this.m_url;
        }

        public boolean isExternalized() {
            return true;
        }

        public String getScriptText() {
            return null;
        }
    }

    public static class JsResourceHandleProvider
    implements JsResource.IHandleProvider {
        private EmbeddedServer m_server;
        private JsResource.IHandleProvider m_realProvider;
        private JsResource m_resource;

        public JsResourceHandleProvider(EmbeddedServer server, JsResource resource) {
            this.m_server = server;
            this.m_resource = resource;
            this.m_realProvider = this.m_resource.getHandleProvider();
        }

        public IJsResourceHandle getHandle(Permutation permutationCtx) {
            try {
                String name = this.m_resource.getUrn();
                String path = "/js/" + name + "/" + permutationCtx;
                URL url = new URL(String.valueOf(this.m_server.getBaseUrl()) + path);
                JsDervlet dervlet = new JsDervlet(name, path, this.m_realProvider.getHandle(permutationCtx));
                this.m_server.addDervlet((CoreDervlet)dervlet, name);
                return new JsResourceHandle(url);
            }
            catch (MalformedURLException e) {
                throw new DsfRuntimeException((Throwable)e);
            }
        }
    }
}

