/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dervlet.defaultdervs;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.vsf.dervlet.CoreDervlet;
import org.eclipse.vjet.vsf.dervlet.DsfDervlet;
import org.eclipse.vjet.vsf.dervlet.DsfDervletUtil;
import org.eclipse.vjet.vsf.dervlet.embedded.server.EmbeddedServer;

public class DervletAdminServlet
extends HttpServlet {
    public static final String EMBEDDED_DERVLET_ADMIN_SERVER = "EmbeddedDervletAdminServer";
    public static final String DERVLET_CLASSNAME = "classname";
    public static final String ESF_TAGLIBS = "esf.taglibs";
    public static final String ESF_OUTPUT_MODE = "esf.outputmode";
    public static final String ESF_CTX_PROVIDER_CLASS = "esf.esfctxproviderclass";
    public static final String ESF_CTX_PROVIDER_METHOD = "esf.esfctxprovidermethod";
    private static final long serialVersionUID = -1492924818343041852L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        EmbeddedServer server = (EmbeddedServer)this.getServletContext().getAttribute(EMBEDDED_DERVLET_ADMIN_SERVER);
        String pathInfo = req.getPathInfo();
        if (server != null && pathInfo != null && "/adddervlet".endsWith(pathInfo)) {
            String dervletClassName = req.getParameter(DERVLET_CLASSNAME);
            DsfDervlet dervlet = null;
            try {
                dervlet = DervletAdminServlet.getDervlet(dervletClassName);
            }
            catch (Exception e) {
                if (e instanceof InstantiationException) {
                    resp.getOutputStream().println("Dervlets must have a default constructor (a constructor with no parameters)");
                }
                if (e instanceof ClassNotFoundException) {
                    resp.getOutputStream().println("Try this:\r\n- Go into the Run -> Run... menu\r\n- Delete the launch configuration for your Dervlet under \"Dervlet\" on the left-hand side\r\n- Re-run the Dervlet launcher\r\n");
                }
                resp.getOutputStream().println(DervletAdminServlet.toMessageString(e));
                resp.setStatus(303);
            }
            if (dervlet != null) {
                Map<String, String> map;
                CoreDervlet installedDervlet = server.getDervlet(dervlet.getServletName());
                if (installedDervlet == null && dervlet != null) {
                    server.addDervlet(dervlet);
                    for (DsfDervlet d : dervlet.getDependentDervlets()) {
                        if (dervlet instanceof DsfDervlet.ServletWrapper) {
                            DsfDervlet.ServletWrapper wrapper = (DsfDervlet.ServletWrapper)dervlet;
                            server.addServlet(wrapper.getServlet(), wrapper.getName(), wrapper.getPath());
                            continue;
                        }
                        server.addDervlet(d);
                    }
                }
                String name = dervlet.getServletName();
                String path = dervlet.getPath();
                if (path == null) {
                    path = String.valueOf('/') + dervlet.getServletName();
                }
                if ((map = dervlet.getDefaultUrlParameters()) != null && map.size() > 0 && name != null && name.trim().length() > 0) {
                    if (name.charAt(0) != '/') {
                        name = String.valueOf('/') + name;
                    }
                    resp.getOutputStream().print(String.valueOf(name) + DsfDervletUtil.getInstance().toUrlParameterPart(map));
                } else {
                    resp.getOutputStream().print(path);
                }
                resp.setStatus(200);
            }
        }
    }

    private static DsfDervlet getDervlet(String dervletClassName) throws Exception {
        DsfDervlet dervlet = null;
        Class<?> dervletClass = Class.forName(dervletClassName);
        try {
            Method createFragmentMethod = dervletClass.getDeclaredMethod("createFragment", null);
            createFragmentMethod.setAccessible(true);
            int mod = createFragmentMethod.getModifiers();
            DNode node = null;
            Object dervletObject = null;
            if (Modifier.isStatic(mod)) {
                node = (DNode)createFragmentMethod.invoke(null, null);
                dervlet = DervletAdminServlet.getDervletByNode(node, dervletObject, dervletClass.getSimpleName());
            } else {
                dervletObject = dervletClass.newInstance();
                if (dervletObject instanceof DsfDervlet) {
                    dervlet = dervletObject;
                } else {
                    node = (DNode)createFragmentMethod.invoke(dervletObject, null);
                    dervlet = DervletAdminServlet.getDervletByNode(node, dervletObject, dervletClass.getSimpleName());
                }
            }
            return dervlet;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        Object dervletObject = dervletClass.newInstance();
        if (dervletObject instanceof DsfDervlet) {
            return (DsfDervlet)dervletObject;
        }
        return dervlet;
    }

    private static DsfDervlet getDervletByNode(DNode node, Object dervletObject, String dervletName) {
        if (dervletObject instanceof CoreDervlet) {
            return (DsfDervlet)dervletObject;
        }
        DsfDervlet dervlet = DsfDervletUtil.getInstance().asDervlet(node, dervletName);
        return dervlet;
    }

    public static String toMessageString(Throwable t) {
        if (t == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(250);
        String message = t.getMessage();
        if (message == null) {
            sb.append(t.toString().trim());
        } else {
            sb.append(t.getClass().getSimpleName()).append(": ").append(message);
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            sb.append(" (nested cause: ").append(cause.toString().trim()).append(')');
        }
        return sb.toString();
    }
}

