/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dapunit;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.dap.rt.DapConfig;
import org.eclipse.vjet.dsf.dap.rt.DapConsoleProxy;
import org.eclipse.vjet.dsf.dap.rt.DapSession;
import org.eclipse.vjet.dsf.dap.rt.IDapConsoleHandler;
import org.eclipse.vjet.dsf.json.JsonArray;
import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.vsf.dapunit.DapUnitConsoleHandler;
import org.eclipse.vjet.vsf.dapunit.UserAgentsEnum;

public class DapConsoleProxyHelper4DapUnit {
    private DapConsoleProxyHelper4DapUnit() {
    }

    public static void enableDapUnitCmdHandlers(DapConfig config) {
        DapConsoleProxy proxy = (DapConsoleProxy)config.findDapConsoleProxy(DapConsoleProxy.class.getSimpleName());
        proxy.addCmdHandler("save", (DapConsoleProxy.ICmdHandler)new SaveCmdHandler());
        proxy.addCmdHandler("config", (DapConsoleProxy.ICmdHandler)new ConfigCmdHandler());
    }

    public static void disableDapUnitCmdHandlers(DapConfig config) {
        DapConsoleProxy proxy = (DapConsoleProxy)config.findDapConsoleProxy(DapConsoleProxy.class.getSimpleName());
        proxy.removeCmdHandler("save");
        proxy.removeCmdHandler("config");
    }

    private static class ConfigCmdHandler
    implements DapConsoleProxy.ICmdHandler {
        private static final Map<String, String> USER_AGENTS_INDEX = new HashMap<String, String>();
        private static final String[] AVAILABLE_USER_AGENTS;

        static {
            USER_AGENTS_INDEX.put(UserAgentsEnum.FF_2_DOT_0.getBrowser(), "FF_2_DOT_0");
            USER_AGENTS_INDEX.put(UserAgentsEnum.FF_3_DOT_0.getBrowser(), "FF_3_DOT_0");
            USER_AGENTS_INDEX.put(UserAgentsEnum.IE_6_DOT_0.getBrowser(), "IE_6_DOT_0");
            AVAILABLE_USER_AGENTS = USER_AGENTS_INDEX.keySet().toArray(new String[0]);
        }

        private ConfigCmdHandler() {
        }

        public static String getUserAgentsEnum(String key) {
            return USER_AGENTS_INDEX.get(key);
        }

        public JsonObject execute(JsonObject jo) {
            JsonObject data = new JsonObject();
            jo.accumulate("data", (Object)data);
            JsonArray uas = new JsonArray();
            String[] stringArray = AVAILABLE_USER_AGENTS;
            int n = AVAILABLE_USER_AGENTS.length;
            int n2 = 0;
            while (n2 < n) {
                String ua = stringArray[n2];
                uas.put((Object)ua);
                ++n2;
            }
            data.accumulate("useragent", (Object)uas);
            return jo;
        }

        public void setDapConsoleProxy(DapConsoleProxy proxy) {
        }
    }

    private static class SaveCmdHandler
    extends DapConsoleProxy.DapConsoleProxyCmdCliHandler {
        private String[] m_userAgents;
        private String[] m_filters;
        private boolean m_userCapturedAjax;
        private static MockAjaxTemplateHandler ajaxHandler = new MockAjaxTemplateHandler();

        private SaveCmdHandler() {
        }

        protected String genCmdLine(JsonObject jo, DapSession session) {
            if (jo.has("configuration")) {
                String[] uas;
                JsonObject config = jo.getJSONObject("configuration");
                if (config.has("useragents") && (uas = this.jsonArr2StrArr(config.getJSONArray("useragents"))) != null) {
                    this.m_userAgents = new String[uas.length];
                    int i = 0;
                    while (i < uas.length) {
                        this.m_userAgents[i] = ConfigCmdHandler.getUserAgentsEnum(uas[i]);
                        ++i;
                    }
                }
                if (config.has("filters")) {
                    this.m_filters = this.jsonArr2StrArr(config.getJSONArray("filters"));
                }
                if (config.has("usercaptureajax")) {
                    this.m_userCapturedAjax = config.getBoolean("usercaptureajax");
                }
            }
            String cmdLine = "GEN_DAP_UNIT";
            String fileName = jo.getString("filename");
            if (!"default".equals(fileName)) {
                cmdLine = String.valueOf(cmdLine) + " ";
                cmdLine = String.valueOf(cmdLine) + fileName;
            }
            return cmdLine;
        }

        private String[] jsonArr2StrArr(JsonArray ja) {
            if (ja == null) {
                return null;
            }
            int len = ja.length();
            if (len == 0) {
                return null;
            }
            String[] sa = new String[len];
            int i = 0;
            while (i < len) {
                sa[i] = ja.getString(i);
                ++i;
            }
            return sa;
        }

        protected void executeCmdLine(String cmdLine, IDapConsoleHandler h) {
            if (h instanceof DapUnitConsoleHandler) {
                DapUnitConsoleHandler handler = (DapUnitConsoleHandler)h;
                handler.setRegexFilters(this.m_filters);
                handler.setUserAgents(this.m_userAgents);
                if (this.m_userCapturedAjax) {
                    handler.addTemplateHandler(ajaxHandler);
                } else {
                    handler.removeTemplateHandler(ajaxHandler);
                }
                handler.handle(cmdLine);
            }
        }

        private static class MockAjaxTemplateHandler
        implements DapUnitConsoleHandler.ITemplateHandler {
            private MockAjaxTemplateHandler() {
            }

            @Override
            public boolean accept(String tempLine) {
                return tempLine.contains("[MockAjax]");
            }

            @Override
            public String handle(String tempLine) {
                return tempLine.replace("[MockAjax]", "getConfig().setEnableMockHttpClient(true);");
            }
        }
    }
}

