/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.cache.postbuild;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.vsf.aggregator.cache.meta.AppJsExternalizationInfo;
import org.eclipse.vjet.vsf.aggregator.cache.meta.ViewJsExternalizationInfo;
import org.eclipse.vjet.vsf.aggregator.cache.postbuild.IOptimizeTocPostProcessorRule;

public class JsOptimizeTocPostProcessor {
    public static boolean optimize(AppJsExternalizationInfo currentAppJsInfo, AppJsExternalizationInfo oldAppJsInfo, boolean isReroll) {
        return JsOptimizeTocPostProcessor.optimize(currentAppJsInfo, oldAppJsInfo, isReroll, null);
    }

    public static boolean optimize(AppJsExternalizationInfo currentAppJsInfo, AppJsExternalizationInfo oldAppJsInfo, boolean isReroll, IOptimizeTocPostProcessorRule rule) {
        boolean isOptimized = false;
        if (isReroll) {
            JsOptimizeTocPostProcessor.checkRerollViewDeletions(currentAppJsInfo, oldAppJsInfo);
        }
        for (ViewJsExternalizationInfo viewInfo : currentAppJsInfo.getAllViewJsInfos()) {
            ViewJsExternalizationInfo oldViewInfo = oldAppJsInfo.getViewJsInfo(viewInfo.getViewId());
            if (oldViewInfo == null) continue;
            for (ViewJsExternalizationInfo.GrouppedJsInfo slotJsInfo : viewInfo.getAllGrouppedJsInfo()) {
                ViewJsExternalizationInfo.GrouppedJsInfo oldSlotJsInfo = oldViewInfo.getGrouppedJsInfo(slotJsInfo.getIndex());
                if (oldSlotJsInfo == null || oldSlotJsInfo.getMd5() == null || oldSlotJsInfo.getOptimizedPath() == null || !oldSlotJsInfo.getMd5().equals(slotJsInfo.getMd5())) continue;
                String opath = oldSlotJsInfo.getOptimizedPath();
                if (rule != null) {
                    opath = rule.getOptimizedPath(oldSlotJsInfo.getRelativePath(), oldSlotJsInfo.getOptimizedPath(), slotJsInfo.getRelativePath(), slotJsInfo.getOptimizedPath());
                }
                slotJsInfo.setOptimizedPath(opath);
                isOptimized = true;
            }
        }
        JsOptimizeTocPostProcessor.optimizeLocaleSpecficViews(currentAppJsInfo, oldAppJsInfo, rule);
        return isOptimized;
    }

    private static void optimizeLocaleSpecficViews(AppJsExternalizationInfo currentAppJsInfo, AppJsExternalizationInfo oldAppJsInfo, IOptimizeTocPostProcessorRule rule) {
        for (ViewJsExternalizationInfo viewInfo : currentAppJsInfo.getAllViewJsInfos()) {
            ViewJsExternalizationInfo oldViewInfo = oldAppJsInfo.getViewJsInfo(viewInfo.getViewId());
            if (oldViewInfo == null) continue;
            Set<String> locales = viewInfo.getLocales();
            for (String locale : locales) {
                for (ViewJsExternalizationInfo.GrouppedJsInfo slotJsInfo : viewInfo.getAllGrouppedJsInfo(locale)) {
                    ViewJsExternalizationInfo.GrouppedJsInfo oldSlotJsInfo = oldViewInfo.getGrouppedJsInfo(slotJsInfo.getIndex(), locale);
                    if (oldSlotJsInfo == null || oldSlotJsInfo.getMd5() == null || oldSlotJsInfo.getOptimizedPath() == null || !oldSlotJsInfo.getMd5().equals(slotJsInfo.getMd5())) continue;
                    String opath = oldSlotJsInfo.getOptimizedPath();
                    if (rule != null) {
                        opath = rule.getOptimizedPath(oldSlotJsInfo.getRelativePath(), oldSlotJsInfo.getOptimizedPath(), slotJsInfo.getRelativePath(), slotJsInfo.getOptimizedPath());
                    }
                    slotJsInfo.setOptimizedPath(opath);
                }
            }
        }
    }

    private static void checkRerollViewDeletions(AppJsExternalizationInfo currentAppJsInfo, AppJsExternalizationInfo oldAppJsInfo) {
        ArrayList<String> deletedViews = new ArrayList<String>();
        if (currentAppJsInfo == null || oldAppJsInfo == null) {
            return;
        }
        for (ViewJsExternalizationInfo oldview : oldAppJsInfo.getAllViewJsInfos()) {
            if (currentAppJsInfo.getViewJsInfo(oldview.getViewId()) != null) continue;
            deletedViews.add(oldview.getViewId());
        }
        if (deletedViews.size() > 0) {
            String errorMessage = "Viewspec(s) " + deletedViews.toString() + " deleted in application spec [" + oldAppJsInfo.getAppId() + "]. Deleting viewspec(s) are not permitted in the train re-rolls.";
            throw new DsfRuntimeException(errorMessage);
        }
    }
}

