/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsdi.agent.remote;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.eclipse.vjet.dsf.jsdi.FunctionSource;
import org.eclipse.vjet.dsf.jsdi.IDebuggerControl;
import org.eclipse.vjet.dsf.jsdi.IGuiCallback;
import org.eclipse.vjet.dsf.jsdi.ISourceInfo;
import org.eclipse.vjet.dsf.jsdi.IVariable;
import org.eclipse.vjet.dsf.jsdi.StackFrameInfo;
import org.eclipse.vjet.dsf.jsdi.agent.remote.IDebuggerClient;

public class DebuggerClient
implements IDebuggerClient {
    private final IGuiCallback m_guiCallback;
    private IDebuggerControl m_debuggerControl;
    private boolean m_sharedClient = false;

    public DebuggerClient(IGuiCallback guiCallback) {
        this(guiCallback, false);
    }

    public DebuggerClient(IGuiCallback guiCallback, boolean shared) {
        this.m_guiCallback = guiCallback;
        this.m_sharedClient = shared;
        try {
            IDebuggerClient stub = (IDebuggerClient)UnicastRemoteObject.exportObject((Remote)this, 0);
            Registry registry = LocateRegistry.createRegistry(1099);
            registry.bind("DebuggerClient", stub);
            System.out.println("DebuggerClient ready");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setShared(boolean set) {
        this.m_sharedClient = set;
    }

    @Override
    public void compileScript(String url, String text) throws RemoteException {
        this.m_debuggerControl.compileScript(url, text);
    }

    @Override
    public void contextSwitch(int frameIndex) throws RemoteException {
        this.m_debuggerControl.contextSwitch(frameIndex);
    }

    @Override
    public String eval(String expr) throws RemoteException {
        return this.m_debuggerControl.eval(expr);
    }

    @Override
    public void evalScript(String url, String text) throws RemoteException {
        this.m_debuggerControl.evalScript(url, text);
    }

    @Override
    public String[] functionNames() throws RemoteException {
        return this.m_debuggerControl.functionNames();
    }

    @Override
    public FunctionSource functionSourceByName(String functionName) throws RemoteException {
        return this.m_debuggerControl.functionSourceByName(functionName);
    }

    @Override
    public int getFrameCount() throws RemoteException {
        return this.m_debuggerControl.getFrameCount();
    }

    @Override
    public StackFrameInfo getFrameInfo(int frameIndex) throws RemoteException {
        return this.m_debuggerControl.getFrameInfo(frameIndex);
    }

    @Override
    public String getObjectValueAsString(long id) throws RemoteException {
        return this.m_debuggerControl.getObjectValueAsString(id);
    }

    @Override
    public boolean isBreakOnEnter() throws RemoteException {
        return this.m_debuggerControl.isBreakOnEnter();
    }

    @Override
    public boolean isBreakOnExceptions() throws RemoteException {
        return this.m_debuggerControl.isBreakOnExceptions();
    }

    @Override
    public boolean isBreakOnReturn() throws RemoteException {
        return this.m_debuggerControl.isBreakOnReturn();
    }

    @Override
    public IVariable[] loadMembers(long id) throws RemoteException {
        return this.m_debuggerControl.loadMembers(id);
    }

    @Override
    public void setBreak() throws RemoteException {
        this.m_debuggerControl.setBreak();
    }

    @Override
    public void setBreakOnEnter(boolean breakOnEnter) throws RemoteException {
        this.m_debuggerControl.setBreakOnEnter(breakOnEnter);
    }

    @Override
    public void setBreakOnExceptions(boolean breakOnExceptions) throws RemoteException {
        this.m_debuggerControl.setBreakOnExceptions(breakOnExceptions);
    }

    @Override
    public void setBreakOnReturn(boolean breakOnReturn) throws RemoteException {
        this.m_debuggerControl.setBreakOnReturn(breakOnReturn);
    }

    @Override
    public void setGuiCallback(IGuiCallback callback) throws RemoteException {
    }

    @Override
    public void setReturnValue(int returnValue) throws RemoteException {
        this.m_debuggerControl.setReturnValue(returnValue);
    }

    @Override
    public boolean shouldBreak() throws RemoteException {
        return this.m_debuggerControl.shouldBreak();
    }

    @Override
    public ISourceInfo getSourceInfo(String url) throws RemoteException {
        return this.m_debuggerControl.getSourceInfo(url);
    }

    @Override
    public boolean stringIsCompilableUnit(String str) throws RemoteException {
        return this.m_debuggerControl.stringIsCompilableUnit(str);
    }

    @Override
    public void connect(IDebuggerControl debuggerControl) throws RemoteException {
        System.out.println("DebuggerClient was connected");
        this.m_debuggerControl = debuggerControl;
        this.m_guiCallback.connect(this);
    }

    @Override
    public void detach(boolean shutdown) throws RemoteException {
        if (this.m_sharedClient) {
            shutdown = false;
        }
        this.m_guiCallback.detach(shutdown);
        if (shutdown) {
            UnicastRemoteObject.unexportObject(this, true);
        }
    }

    @Override
    public void dispatchNextGuiEvent() throws InterruptedException, RemoteException {
        this.m_guiCallback.dispatchNextGuiEvent();
    }

    @Override
    public void enterInterrupt(StackFrameInfo frameInfo, String threadTitle, String alertMessage) throws RemoteException {
        this.m_guiCallback.enterInterrupt(frameInfo, threadTitle, alertMessage);
    }

    @Override
    public int[] getBreakPoints(String url) throws RemoteException {
        return this.m_guiCallback.getBreakPoints(url);
    }

    @Override
    public boolean isGuiEventThread() throws RemoteException {
        return this.m_guiCallback.isGuiEventThread();
    }

    @Override
    public void updateSourceText(ISourceInfo sourceInfo) throws RemoteException {
        this.m_guiCallback.updateSourceText(sourceInfo);
    }
}

