/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp.file;

import java.net.URI;
import org.eclipse.vjet.dsf.js.dbgp.ISourceProvider;
import org.eclipse.vjet.dsf.js.dbgp.SourceProvider;
import org.eclipse.vjet.dsf.js.dbgp.file.IVFile;
import org.eclipse.vjet.dsf.js.dbgp.file.IVFileManager;

public class VFileSourceProvider
extends SourceProvider
implements ISourceProvider {
    private IVFileManager m_manager;

    public VFileSourceProvider(IVFileManager manager) {
        this.m_manager = manager;
    }

    @Override
    public String getSource(String filePath, int beginLine, int endLine) {
        if (filePath == null) {
            throw new IllegalArgumentException("File path shouldn't be null!");
        }
        URI fileUri = URI.create(filePath);
        IVFile file = this.m_manager.resolve(fileUri);
        String contents = file != null ? file.getContents() : "";
        return this.getContents(contents, beginLine, endLine);
    }

    @Override
    public String[] list() {
        IVFile[] files = this.m_manager.getFiles();
        String[] uris = new String[files.length];
        int i = 0;
        while (i < uris.length) {
            uris[i] = files[i].toURI().toString();
            ++i;
        }
        return uris;
    }
}

