/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DSelect;
import org.eclipse.vjet.dsf.html.js.JSDebug;
import org.eclipse.vjet.dsf.html.js.JSElement;
import org.eclipse.vjet.dsf.html.js.JSOption;
import org.eclipse.vjet.dsf.html.js.JSOptionsArray;
import org.eclipse.vjet.dsf.html.js.JSWindow;
import org.mozilla.mod.javascript.Scriptable;

public class JSSelect
extends JSElement {
    private DSelect select = null;
    private JSOptionsArray options = null;
    public String name = null;
    public String formId = null;

    private JSSelect() {
    }

    public JSSelect(JSWindow window, DSelect select) {
        super(window, (BaseHtmlElement)select);
        this.window = window;
        this.select = select;
        this.name = select.getHtmlName();
        this.formId = select.getAttribute("form-id");
        this.options = new JSOptionsArray(window, this);
        String[] functions = new String[]{"add", "remove", "blur", "focus"};
        this.defineProperty("value", JSSelect.class, 2);
    }

    @Override
    public String getClassName() {
        return "JSSelectElement";
    }

    @Override
    public JSWindow getWindow() {
        return this.window;
    }

    public Object getForm() {
        return this.window.findFormElement(this.formId, null);
    }

    public void add(BaseHtmlElement element, BaseHtmlElement before) {
        this.select.htmlAdd(element, before);
    }

    public void remove(int index) {
        this.select.htmlRemove(index);
    }

    public void blur() {
        JSDebug.println("blur is invoked on " + this.name);
    }

    public void focus() {
        JSDebug.println("focus is invoked on " + this.name);
    }

    public String getType() {
        return this.select.getHtmlType();
    }

    public int getSelectedIndex() {
        String index;
        int selectedIndex = 0;
        if (this.window.windowState != JSWindow.IN_SERVER) {
            selectedIndex = this.select.getHtmlSelectedIndex();
        }
        if (this.window.windowState != JSWindow.IN_LOADING && (index = this.window.getJSListener().doAction(13, this.name, String.valueOf(selectedIndex), this.formId)) != null && index.length() > 0) {
            try {
                selectedIndex = Integer.parseInt(index);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        if (this.window.windowState != JSWindow.IN_LOADING) {
            this.window.getJSListener().doAction(14, this.name, String.valueOf(selectedIndex), this.formId);
        }
        this.select.setHtmlSelectedIndex(selectedIndex);
    }

    public String getValue() {
        if (this.window.windowState == JSWindow.IN_LOADING) {
            return String.valueOf(this.select.getHtmlSelectedIndex());
        }
        String value = null;
        JSOption option = this.options.getOption(this.select.getHtmlSelectedIndex());
        value = option.getValue();
        if (value.length() == 0) {
            value = option.getText();
        }
        return this.window.getJSListener().doAction(15, this.name, value, this.formId);
    }

    public void setValue(String value) {
        this.select.setHtmlValue(value);
    }

    public Scriptable getOptions() {
        return this.options;
    }

    public int getLength() {
        return this.select.getHtmlLength();
    }

    public boolean getDisabled() {
        return this.select.getHtmlDisabled();
    }

    public void setDisabled(boolean disabled) {
        this.select.setHtmlDisabled(disabled);
    }

    public boolean getMultiple() {
        return this.select.getHtmlMultiple();
    }

    public void setMultiple(boolean multiple) {
        this.select.setHtmlMultiple(multiple);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.select.setHtmlName(name);
        this.name = name;
    }

    public int getSize() {
        return this.select.getHtmlSize();
    }

    public void setSize(int size) {
        this.select.setHtmlSize(size);
    }

    public int getTabIndex() {
        return this.select.getHtmlTabIndex();
    }

    public void setTabIndex(int tabIndex) {
        this.select.setHtmlTabIndex(tabIndex);
    }

    public Object get(int index, Scriptable start) {
        return this.options.get(index, start);
    }

    @Override
    public Object get(String name, Scriptable start) {
        Object obj = super.get(name, start);
        if (obj == NOT_FOUND) {
            obj = this.window.get(name, start);
        }
        return obj;
    }

    public int getOptionIndex(String optionValue) {
        return this.options.getIndex(optionValue);
    }

    @Override
    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string")) {
            return this.name;
        }
        if (type.equals("object")) {
            return this;
        }
        if (type.equals("number")) {
            return "0";
        }
        return null;
    }

    public DSelect getHtmlSelect() {
        return this.select;
    }

    public void addOption(JSOption option) {
        this.select.add((DNode)option.getDNode());
        this.options.add(option);
        this.getListener().onElementChange((BaseHtmlElement)this.select);
    }

    public void removeAllOptions() {
        this.options.removeAll();
        this.getListener().onElementChange((BaseHtmlElement)this.select);
    }
}

