/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import org.eclipse.vjet.dsf.active.event.IDomEventBindingListener;
import org.eclipse.vjet.dsf.dap.util.DapDomHelper;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DImg;
import org.eclipse.vjet.dsf.html.dom.DScript;
import org.eclipse.vjet.dsf.liveconnect.IDLCDispatcher;
import org.eclipse.vjet.dsf.liveconnect.client.DLCClientHelper;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCClient;
import org.eclipse.vjet.dsf.liveconnect.client.NativeEvent;
import org.w3c.dom.Node;

public class DapDomEventBindingListener
implements IDomEventBindingListener {
    private final IDLCDispatcher m_dlcDispatcher;
    private final IDLCClient m_dlcClient;

    public DapDomEventBindingListener(IDLCDispatcher dlcDispatcher, IDLCClient dlcClient) {
        this.m_dlcDispatcher = dlcDispatcher;
        this.m_dlcClient = dlcClient;
    }

    @Override
    public void eventBound(Node elem, String eventType) {
        String enabler;
        NativeEvent event = NativeEvent.valueOf((String)eventType);
        if (event.equals((Object)NativeEvent.load) && elem instanceof DImg) {
            event = NativeEvent.imageload;
        }
        if (event.equals((Object)NativeEvent.load) && elem instanceof DScript) {
            event = NativeEvent.scriptLoad;
        }
        if (event.equals((Object)NativeEvent.readystatechange) && elem instanceof DScript) {
            event = NativeEvent.scriptReadyStateChange;
        }
        if (event == NativeEvent.change || event == NativeEvent.click) {
            return;
        }
        if ((event.equals((Object)NativeEvent.readystatechange) || event.equals((Object)NativeEvent.load) || event.equals((Object)NativeEvent.unload)) && elem instanceof DHtmlDocument) {
            return;
        }
        String path = DapDomHelper.getPath(elem);
        if (path == null) {
            return;
        }
        if (event.equals((Object)NativeEvent.scroll) && elem instanceof DHtmlDocument) {
            path = "window";
        }
        if ((enabler = DLCClientHelper.dlcClientEventEnablerViaPath((String)path, (NativeEvent)event, (IDLCClient)this.m_dlcClient)) != null) {
            this.m_dlcDispatcher.send(enabler);
        }
    }

    @Override
    public boolean isEventBinding(Node elem, String name) {
        NativeEvent event = NativeEvent.valueOf((String)name);
        return event != null;
    }
}

