/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.mod.javascript.jdk13;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.ContextFactory;
import org.mozilla.mod.javascript.InterfaceAdapter;
import org.mozilla.mod.javascript.Kit;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.VMBridge;

public class VMBridge_jdk13
extends VMBridge {
    private ThreadLocal contextLocal = new ThreadLocal();

    @Override
    public Object getThreadContextHelper() {
        Object[] storage = (Object[])this.contextLocal.get();
        if (storage == null) {
            storage = new Object[1];
            this.contextLocal.set(storage);
        }
        return storage;
    }

    @Override
    protected Context getContext(Object contextHelper) {
        Object[] storage = (Object[])contextHelper;
        return (Context)storage[0];
    }

    @Override
    public void setContext(Object contextHelper, Context cx) {
        Object[] storage = (Object[])contextHelper;
        storage[0] = cx;
    }

    @Override
    protected ClassLoader getCurrentThreadClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    protected boolean tryToMakeAccessible(Object accessibleObject) {
        if (!(accessibleObject instanceof AccessibleObject)) {
            return false;
        }
        AccessibleObject accessible = (AccessibleObject)accessibleObject;
        if (accessible.isAccessible()) {
            return true;
        }
        try {
            accessible.setAccessible(true);
        }
        catch (Exception exception) {}
        return accessible.isAccessible();
    }

    @Override
    protected Object getInterfaceProxyHelper(ContextFactory cf, Class[] interfaces) {
        Constructor<?> c;
        ClassLoader loader = interfaces[0].getClassLoader();
        Class<?> cl = Proxy.getProxyClass(loader, interfaces);
        try {
            c = cl.getConstructor(InvocationHandler.class);
        }
        catch (NoSuchMethodException ex) {
            throw Kit.initCause(new IllegalStateException(), ex);
        }
        return c;
    }

    @Override
    protected Object newInterfaceProxy(Object proxyHelper, final ContextFactory cf, final InterfaceAdapter adapter, final Object target, final Scriptable topScope) {
        Object proxy;
        Constructor c = (Constructor)proxyHelper;
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                return adapter.invoke(cf, target, topScope, method, args);
            }
        };
        try {
            proxy = c.newInstance(handler);
        }
        catch (InvocationTargetException ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
        catch (IllegalAccessException ex) {
            throw Kit.initCause(new IllegalStateException(), ex);
        }
        catch (InstantiationException ex) {
            throw Kit.initCause(new IllegalStateException(), ex);
        }
        return proxy;
    }

    @Override
    protected boolean isVarArgs(Member member) {
        return false;
    }
}

