/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.mod.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.CompilationUnitBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.MultipleTypeBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.mod.wst.jsdt.internal.compiler.util.CompoundNameVector;
import org.eclipse.mod.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.mod.wst.jsdt.internal.compiler.util.HashtableOfType;
import org.eclipse.mod.wst.jsdt.internal.compiler.util.ObjectVector;
import org.eclipse.mod.wst.jsdt.internal.compiler.util.SimpleNameVector;
import org.eclipse.mod.wst.jsdt.internal.compiler.util.Util;

public class CompilationUnitScope
extends BlockScope {
    public LookupEnvironment environment;
    public CompilationUnitDeclaration referenceContext;
    public char[][] currentPackageName;
    public PackageBinding fPackage;
    public ImportBinding[] imports;
    public HashtableOfObject typeOrPackageCache;
    private CompoundNameVector qualifiedReferences;
    private SimpleNameVector simpleNameReferences;
    private ObjectVector referencedTypes;
    private ObjectVector referencedSuperTypes;
    HashtableOfType constantPoolNameUsage;
    public int analysisIndex;
    private int captureID = 1;
    public ReferenceBinding superBinding;
    private MethodScope methodScope;
    private ClassScope classScope;
    public int temporaryAnalysisIndex;
    public HashSet externalCompilationUnits = new HashSet();
    public static final char FILENAME_DOT_SUBSTITUTION = '#';

    public CompilationUnitScope(CompilationUnitDeclaration unit, LookupEnvironment environment) {
        super(4, null);
        this.environment = environment;
        this.referenceContext = unit;
        unit.scope = this;
        char[][] pkgName = unit.currentPackage == null ? (Object)(unit.compilationResult != null ? unit.compilationResult.getPackageName() : null) : unit.currentPackage.tokens;
        this.currentPackageName = pkgName == null ? CharOperation.NO_CHAR_CHAR : pkgName;
        this.referencedTypes = new ObjectVector();
        if (this.compilerOptions().produceReferenceInfo) {
            this.qualifiedReferences = new CompoundNameVector();
            this.simpleNameReferences = new SimpleNameVector();
            this.referencedSuperTypes = new ObjectVector();
        } else {
            this.qualifiedReferences = null;
            this.simpleNameReferences = null;
            this.referencedSuperTypes = null;
        }
    }

    protected CompilationUnitScope(LookupEnvironment environment) {
        super(4, null);
        this.environment = environment;
        this.referencedTypes = new ObjectVector();
        if (this.compilerOptions().produceReferenceInfo) {
            this.qualifiedReferences = new CompoundNameVector();
            this.simpleNameReferences = new SimpleNameVector();
            this.referencedSuperTypes = new ObjectVector();
        } else {
            this.qualifiedReferences = null;
            this.simpleNameReferences = null;
            this.referencedSuperTypes = null;
        }
    }

    @Override
    public MethodScope methodScope() {
        if (this.superBinding != null && this.methodScope == null) {
            this.methodScope = new MethodScope(this.classScope, this.referenceContext(), false);
        }
        return this.methodScope;
    }

    @Override
    public ClassScope classScope() {
        if (this.classScope != null) {
            return this.classScope;
        }
        return super.classScope();
    }

    public PackageBinding getDefaultPackage() {
        return this.environment.defaultPackage;
    }

    @Override
    public void addLocalVariable(LocalVariableBinding binding) {
        super.addLocalVariable(binding);
        this.environment.defaultPackage.addBinding(binding, binding.name, 3);
        this.fPackage.addBinding(binding, binding.name, 3);
    }

    void checkAndSetImports() {
        if (this.referenceContext.imports == null) {
            this.imports = this.getDefaultImports();
            return;
        }
        int numberOfStatements = this.referenceContext.imports.length;
        int numberOfImports = numberOfStatements + 1;
        int i = 0;
        while (i < numberOfStatements) {
            ImportReference importReference = this.referenceContext.imports[i];
            if ((importReference.bits & 0x20000) != 0 && CharOperation.equals(JAVA_LANG, importReference.tokens)) {
                --numberOfImports;
                break;
            }
            ++i;
        }
        ImportBinding[] resolvedImports = new ImportBinding[numberOfImports];
        resolvedImports[0] = this.getDefaultImports()[0];
        int index = 1;
        int i2 = 0;
        while (i2 < numberOfStatements) {
            block10: {
                ImportReference importReference = this.referenceContext.imports[i2];
                char[][] compoundName = importReference.tokens;
                int j = 0;
                while (j < index) {
                    ImportBinding resolved = resolvedImports[j];
                    if (resolved.onDemand != ((importReference.bits & 0x20000) != 0) || !CharOperation.equals(compoundName, resolvedImports[j].compoundName)) {
                        ++j;
                        continue;
                    }
                    break block10;
                }
                if ((importReference.bits & 0x20000) != 0) {
                    Binding importBinding;
                    if (!CharOperation.equals(compoundName, this.currentPackageName) && (importBinding = this.findImport(compoundName, compoundName.length)).isValidBinding()) {
                        resolvedImports[index++] = new ImportBinding(compoundName, true, importBinding, importReference);
                    }
                } else {
                    resolvedImports[index++] = new ImportBinding(compoundName, false, null, importReference);
                }
            }
            ++i2;
        }
        if (resolvedImports.length > index) {
            ImportBinding[] importBindingArray = resolvedImports;
            resolvedImports = new ImportBinding[index];
            System.arraycopy(importBindingArray, 0, resolvedImports, 0, index);
        }
        this.imports = resolvedImports;
    }

    public Binding findImport(char[][] compoundName, boolean onDemand) {
        if (onDemand) {
            return this.findImport(compoundName, compoundName.length);
        }
        return this.findSingleImport(compoundName);
    }

    private Binding findImport(char[][] compoundName, int length) {
        ReferenceBinding type;
        int i;
        Binding binding;
        block13: {
            this.recordQualifiedReference(compoundName);
            binding = this.environment.getTopLevelPackage(compoundName[0]);
            i = 1;
            if (binding != null) {
                PackageBinding packageBinding = binding;
                while (i < length) {
                    int type2 = i + 1 == length ? 8192 : 16384;
                    if ((binding = packageBinding.getTypeOrPackage(compoundName[i++], type2)) == null || !binding.isValidBinding()) {
                        binding = null;
                    } else {
                        if (i == length && binding instanceof CompilationUnitBinding) {
                            return binding;
                        }
                        if (binding instanceof PackageBinding) {
                            packageBinding = (PackageBinding)binding;
                            continue;
                        }
                    }
                    break block13;
                }
                return packageBinding;
            }
        }
        if (binding == null) {
            if (this.environment.defaultPackage == null || this.compilerOptions().complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), null, 1);
            }
            type = this.findType(compoundName[0], this.environment.defaultPackage, this.environment.defaultPackage);
            if (type == null || !type.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), null, 1);
            }
            i = 1;
        } else {
            type = (ReferenceBinding)binding;
        }
        while (i < length) {
            char[] name;
            if (!type.canBeSeenBy(this.environment.defaultPackage)) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), type, 2);
            }
            if ((type = type.getMemberType(name = compoundName[i++])) != null) continue;
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), null, 1);
        }
        if (!type.canBeSeenBy(this.environment.defaultPackage)) {
            return new ProblemReferenceBinding(compoundName, type, 2);
        }
        return type;
    }

    private Binding findSingleImport(char[][] compoundName) {
        if (compoundName.length == 1) {
            if (this.environment.defaultPackage == null || this.compilerOptions().complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(compoundName, null, 1);
            }
            ReferenceBinding typeBinding = this.findType(compoundName[0], this.environment.defaultPackage, this.environment.defaultPackage);
            if (typeBinding == null) {
                return new ProblemReferenceBinding(compoundName, null, 1);
            }
            return typeBinding;
        }
        return this.findImport(compoundName, compoundName.length);
    }

    ImportBinding[] getDefaultImports() {
        PackageBinding importBinding = this.environment.defaultPackage;
        if (importBinding != null) {
            importBinding.isValidBinding();
        }
        ImportBinding systemJSBinding = null;
        if (this.environment.defaultImports != null) {
            systemJSBinding = this.environment.defaultImports[0];
        }
        ImportBinding[] defaultImports = null;
        Object contextIncludes = null;
        if (contextIncludes != null && (contextIncludes).length > 0) {
            ArrayList<ImportBinding> list = new ArrayList<ImportBinding>();
            list.add(systemJSBinding);
            int i = 0;
            while (i < (contextIncludes).length) {
                String include = contextIncludes[i];
                if (include != null) {
                    char[][] qualifiedName;
                    Binding binding;
                    int index = Util.indexOfJavaLikeExtension(include);
                    if (index >= 0) {
                        include = include.substring(0, index);
                    }
                    if ((binding = this.findImport(qualifiedName = CharOperation.splitOn('/', (include = include.replace('.', '#')).toCharArray()), qualifiedName.length)).isValidBinding()) {
                        list.add(new ImportBinding(qualifiedName, true, binding, null));
                    }
                }
                ++i;
            }
            defaultImports = list.toArray(new ImportBinding[list.size()]);
        } else {
            defaultImports = new ImportBinding[]{systemJSBinding};
        }
        return defaultImports;
    }

    public final Binding getImport(char[][] compoundName, boolean onDemand) {
        if (onDemand) {
            return this.findImport(compoundName, compoundName.length);
        }
        return this.findSingleImport(compoundName);
    }

    public int nextCaptureID() {
        return this.captureID++;
    }

    @Override
    public ProblemReporter problemReporter() {
        ProblemReporter problemReporter = this.referenceContext.problemReporter;
        problemReporter.referenceContext = this.referenceContext;
        return problemReporter;
    }

    void recordQualifiedReference(char[][] qualifiedName) {
        if (this.qualifiedReferences == null) {
            return;
        }
        int length = ((char[][])qualifiedName).length;
        if (length > 1) {
            while (!this.qualifiedReferences.contains((char[][])qualifiedName)) {
                this.qualifiedReferences.add((char[][])qualifiedName);
                if (length == 2) {
                    this.recordSimpleReference(qualifiedName[0]);
                    this.recordSimpleReference(qualifiedName[1]);
                    return;
                }
                this.recordSimpleReference(qualifiedName[--length]);
                char[][] cArray = qualifiedName;
                char[][] cArrayArray = new char[length][];
                qualifiedName = cArrayArray;
                System.arraycopy(cArray, 0, cArrayArray, 0, length);
            }
        } else if (length == 1) {
            this.recordSimpleReference(qualifiedName[0]);
        }
    }

    void recordReference(char[][] qualifiedEnclosingName, char[] simpleName) {
        this.recordQualifiedReference(qualifiedEnclosingName);
        this.recordSimpleReference(simpleName);
    }

    void recordReference(ReferenceBinding type, char[] simpleName) {
        ReferenceBinding actualType = this.typeToRecord(type);
        if (actualType != null) {
            this.recordReference(actualType.compoundName, simpleName);
        }
    }

    void recordSimpleReference(char[] simpleName) {
        if (this.simpleNameReferences == null) {
            return;
        }
        if (!this.simpleNameReferences.contains(simpleName)) {
            this.simpleNameReferences.add(simpleName);
        }
    }

    void recordSuperTypeReference(TypeBinding type) {
        if (this.referencedSuperTypes == null) {
            return;
        }
        ReferenceBinding actualType = this.typeToRecord(type);
        if (actualType != null && !this.referencedSuperTypes.containsIdentical(actualType)) {
            this.referencedSuperTypes.add(actualType);
        }
    }

    public void recordTypeConversion(TypeBinding superType, TypeBinding subType) {
        this.recordSuperTypeReference(subType);
    }

    void recordTypeReference(TypeBinding type) {
        if (this.referencedTypes == null) {
            return;
        }
        ReferenceBinding actualType = this.typeToRecord(type);
        if (actualType != null && !this.referencedTypes.containsIdentical(actualType)) {
            this.referencedTypes.add(actualType);
        }
    }

    void recordTypeReferences(TypeBinding[] types) {
        if (this.referencedTypes == null) {
            return;
        }
        if (types == null || types.length == 0) {
            return;
        }
        int i = 0;
        int max = types.length;
        while (i < max) {
            ReferenceBinding actualType = this.typeToRecord(types[i]);
            if (actualType != null && !this.referencedTypes.containsIdentical(actualType)) {
                this.referencedTypes.add(actualType);
            }
            ++i;
        }
    }

    Binding resolveSingleImport(ImportBinding importBinding) {
        if (importBinding.resolvedImport == null) {
            importBinding.resolvedImport = this.findSingleImport(importBinding.compoundName);
            if (!importBinding.resolvedImport.isValidBinding() || importBinding.resolvedImport instanceof PackageBinding) {
                if (this.imports != null) {
                    ImportBinding[] newImports = new ImportBinding[this.imports.length - 1];
                    int i = 0;
                    int n = 0;
                    int max = this.imports.length;
                    while (i < max) {
                        if (this.imports[i] != importBinding) {
                            newImports[n++] = this.imports[i];
                        }
                        ++i;
                    }
                    this.imports = newImports;
                }
                return null;
            }
        }
        return importBinding.resolvedImport;
    }

    public void storeDependencyInfo() {
        int i = 0;
        while (i < this.referencedSuperTypes.size) {
            ReferenceBinding superclass;
            ReferenceBinding enclosing;
            ReferenceBinding type = (ReferenceBinding)this.referencedSuperTypes.elementAt(i);
            if (!this.referencedTypes.containsIdentical(type)) {
                this.referencedTypes.add(type);
            }
            if (!type.isLocalType() && (enclosing = type.enclosingType()) != null) {
                this.recordSuperTypeReference(enclosing);
            }
            if ((superclass = type.superclass()) != null) {
                this.recordSuperTypeReference(superclass);
            }
            ++i;
        }
        i = 0;
        int l = this.referencedTypes.size;
        while (i < l) {
            ReferenceBinding type = (ReferenceBinding)this.referencedTypes.elementAt(i);
            if (type instanceof MultipleTypeBinding) {
                ReferenceBinding[] types = ((MultipleTypeBinding)type).types;
                int j = 0;
                while (j < types.length) {
                    if (!types[j].isLocalType()) {
                        this.recordQualifiedReference(types[j].isMemberType() ? CharOperation.splitOn('.', types[j].readableName()) : types[j].compoundName);
                    }
                    ++j;
                }
            } else if (!type.isLocalType()) {
                this.recordQualifiedReference(type.isMemberType() ? CharOperation.splitOn('.', type.readableName()) : type.compoundName);
            }
            ++i;
        }
        int size = this.qualifiedReferences.size;
        char[][][] qualifiedRefs = new char[size][][];
        int i2 = 0;
        while (i2 < size) {
            qualifiedRefs[i2] = this.qualifiedReferences.elementAt(i2);
            ++i2;
        }
        this.referenceContext.compilationResult.qualifiedReferences = qualifiedRefs;
        size = this.simpleNameReferences.size;
        char[][] simpleRefs = new char[size][];
        int i3 = 0;
        while (i3 < size) {
            simpleRefs[i3] = this.simpleNameReferences.elementAt(i3);
            ++i3;
        }
        this.referenceContext.compilationResult.simpleNameReferences = simpleRefs;
    }

    @Override
    public String toString() {
        return "--- JavaScriptUnit Scope : " + new String(this.referenceContext.getFileName());
    }

    private ReferenceBinding typeToRecord(TypeBinding type) {
        while (type.isArrayType()) {
            type = ((ArrayBinding)type).leafComponentType;
        }
        switch (type.kind()) {
            case 132: {
                return null;
            }
        }
        if (type instanceof CompilationUnitBinding) {
            return null;
        }
        ReferenceBinding refType = (ReferenceBinding)type;
        if (refType.isLocalType()) {
            return null;
        }
        return refType;
    }

    public void cleanup() {
        if (this.referencedTypes != null) {
            int i = 0;
            int l = this.referencedTypes.size;
            while (i < l) {
                Object obj = this.referencedTypes.elementAt(i);
                if (obj instanceof SourceTypeBinding) {
                    SourceTypeBinding type = (SourceTypeBinding)obj;
                    type.cleanup();
                }
                ++i;
            }
        }
    }

    public void addExternalVar(LocalVariableBinding binding) {
        this.externalCompilationUnits.add(binding.declaringScope.compilationUnitScope());
    }
}

