/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import org.eclipse.mod.wst.jsdt.core.ast.IConditionalExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.mod.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;

public class ConditionalExpression
extends OperatorExpression
implements IConditionalExpression {
    public Expression condition;
    public Expression valueIfTrue;
    public Expression valueIfFalse;
    public Constant optimizedBooleanConstant;
    public Constant optimizedIfTrueConstant;
    public Constant optimizedIfFalseConstant;
    int trueInitStateIndex = -1;
    int falseInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ConditionalExpression(Expression condition, Expression valueIfTrue, Expression valueIfFalse) {
        this.condition = condition;
        this.valueIfTrue = valueIfTrue;
        this.valueIfFalse = valueIfFalse;
        this.sourceStart = condition.sourceStart;
        this.sourceEnd = valueIfFalse.sourceEnd;
    }

    @Override
    public int nullStatus(FlowInfo flowInfo) {
        int ifFalseNullStatus;
        Constant cst = this.condition.optimizedBooleanConstant();
        if (cst != Constant.NotAConstant) {
            if (cst.booleanValue()) {
                return this.valueIfTrue.nullStatus(flowInfo);
            }
            return this.valueIfFalse.nullStatus(flowInfo);
        }
        int ifTrueNullStatus = this.valueIfTrue.nullStatus(flowInfo);
        if (ifTrueNullStatus == (ifFalseNullStatus = this.valueIfFalse.nullStatus(flowInfo))) {
            return ifTrueNullStatus;
        }
        return 0;
    }

    @Override
    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? this.constant : this.optimizedBooleanConstant;
    }

    @Override
    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.condition.printExpression(indent, output).append(" ? ");
        this.valueIfTrue.printExpression(0, output).append(" : ");
        return this.valueIfFalse.printExpression(0, output);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.condition.traverse(visitor, scope);
            this.valueIfTrue.traverse(visitor, scope);
            this.valueIfFalse.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public int getASTType() {
        return 24;
    }
}

