/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.view.ast;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.core.compiler.IProblem;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;

class ASTTreeLabelProvider
extends LabelProvider {
    private boolean isRecoveryUnit;

    public ASTTreeLabelProvider(boolean isRecoveryUnit) {
        this.isRecoveryUnit = isRecoveryUnit;
    }

    public String getText(Object element) {
        String simpleClassName = element.getClass().getSimpleName();
        if (element instanceof IASTNode) {
            IASTNode node = (IASTNode)element;
            String offset = "[" + node.sourceStart() + "," + node.sourceEnd() + "]";
            if (element instanceof CompilationUnitDeclaration) {
                if (this.isRecoveryUnit) {
                    return String.valueOf(simpleClassName) + offset + " (Recovery)";
                }
                return String.valueOf(simpleClassName) + offset + " (Original)";
            }
            return String.valueOf(simpleClassName) + offset;
        }
        if (element instanceof IProblem) {
            IProblem problem = (IProblem)element;
            return String.valueOf(simpleClassName) + "[id=" + problem.getID() + "]";
        }
        return simpleClassName;
    }
}

