/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text.completion;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.internal.core.Member;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.dltk.mod.internal.core.VjoSourceType;
import org.eclipse.dltk.mod.ui.text.completion.HTMLPrinter;
import org.eclipse.dltk.mod.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.dltk.mod.ui.text.completion.TypeProposalInfo;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.eclipse.internal.ui.scriptdoc.JavaDoc2HTMLTextReader;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.ImportRewriter;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.VjoProposalAditionalInfoGenerator;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjoCompletionProposal
extends ScriptCompletionProposal
implements ICompletionProposalExtension4 {
    private boolean m_isAutoInsert;
    private ImportRewriter needsRewriter = new ImportRewriter();
    private Object extraInfo;
    private static final String PERS_FOLDER = "org.eclipse.vjet.eclipse.ui";
    private static final String PERS_FILENAME = "additionalCompletionTemplate.html";

    public VjoCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance);
        this.setContextInformation(null);
    }

    public VjoCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance, boolean isInDoc) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance, isInDoc);
        this.setContextInformation(null);
    }

    protected boolean isSmartTrigger(char trigger) {
        return trigger == '$';
    }

    protected boolean isValidPrefix(String prefix) {
        if (this.getProposalInfo() instanceof TypeProposalInfo && prefix.contains(".")) {
            return this.isPrefix(prefix.substring(prefix.lastIndexOf(46) + 1), this.getDisplayString());
        }
        return this.isPrefix(prefix, this.getDisplayString());
    }

    public void setAutoInsert(boolean isAutoInsert) {
        this.m_isAutoInsert = isAutoInsert;
    }

    public boolean isAutoInsertable() {
        return this.m_isAutoInsert;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        IModelElement element = this.getModelElement();
        String info = VjoCompletionProposal.getAdditionalPropesalInfo(element, this.getCSSStyles());
        return info;
    }

    private static void generateTempFolder(URL baseUrl, boolean create) {
        if (baseUrl == null) {
            return;
        }
        try {
            URL url = new URL(baseUrl, PERS_FOLDER);
            File dir = new File(url.getFile());
            if (!dir.exists() && create) {
                dir.mkdir();
            }
        }
        catch (IOException iOException) {}
    }

    public static String getAdditionalPropesalInfo(IModelElement element, String css) {
        String info = null;
        if (element != null) {
            VjoSourceModule module = null;
            if (element instanceof Member) {
                try {
                    if (element.getParent() instanceof VjoSourceModule) {
                        module = (VjoSourceModule)element.getParent();
                    } else if (element.getParent().getParent() instanceof VjoSourceModule) {
                        module = (VjoSourceModule)element.getParent().getParent();
                    }
                }
                catch (Exception e) {
                    DLTKCore.warn((String)e.toString(), (Throwable)e);
                    return null;
                }
            }
            if (module == null) {
                return info;
            }
            String name = element.getElementName();
            TypeSpaceMgr mgr = TypeSpaceMgr.getInstance();
            IJstType type = mgr.findType((TypeName)module.getTypeName());
            if (type == null) {
                return "";
            }
            IJstProperty property = type.getProperty(name);
            IJstMethod method = type.getMethod(name);
            ArrayList allSupportedExplorers = new ArrayList();
            String briefInfo = "";
            if (property != null && property.getDoc() != null) {
                info = property.getDoc().getComment();
                briefInfo = VjoCompletionProposal.getElementBriefDesc(property);
                VjoCompletionProposal.fillAllSupportedExplorer(property, allSupportedExplorers);
            } else if (method != null && method.getDoc() != null) {
                info = method.getDoc().getComment();
                briefInfo = VjoCompletionProposal.getElementBriefDesc(method);
                VjoCompletionProposal.fillAllSupportedExplorer(method, allSupportedExplorers);
            }
            if (info != null) {
                try {
                    VjoCompletionProposal.copyHtmlTemplateFromBundleToTemp();
                    VjoCompletionProposal.copyIconsFromBundleToTemp();
                    info = info.replace("/", "");
                    info = info.replace("*", "");
                    Location configLoc = Platform.getConfigurationLocation();
                    File persFile = null;
                    try {
                        URL url = new URL(configLoc.getURL(), PERS_FOLDER);
                        File dir = new File(url.getFile());
                        url = new URL(dir.toURL(), PERS_FILENAME);
                        persFile = new File(url.getFile());
                        if (persFile != null) {
                            FileReader readerSuc = new FileReader(persFile);
                            JavaDoc2HTMLTextReader reader2 = new JavaDoc2HTMLTextReader(readerSuc);
                            String wholeInfo = VjoCompletionProposal.getString((Reader)((Object)reader2));
                            wholeInfo = wholeInfo.replace("<%=browserSupported%>", VjoCompletionProposal.getSupportedTypesStirng(allSupportedExplorers, "BrowserType."));
                            String domLevel = VjoCompletionProposal.getSupportedTypesStirng(allSupportedExplorers, "DomLevel.");
                            if (domLevel.length() > 0) {
                                wholeInfo = wholeInfo.replace("<%=DOMLevel%>", "<b>DOM level</b><br>" + VjoCompletionProposal.getSupportedTypesStirng(allSupportedExplorers, "DomLevel.") + "<br>");
                            }
                            wholeInfo = wholeInfo.replace("<%=MinJSVersion%>", VjoCompletionProposal.translateCharacterToNumber(VjoCompletionProposal.getSupportedTypesStirng(allSupportedExplorers, "JsVersion.")));
                            wholeInfo = wholeInfo.replace("<%=briefInfo%>", briefInfo);
                            wholeInfo = wholeInfo.replace("<%=images%>", VjoCompletionProposal.getIcon(allSupportedExplorers));
                            wholeInfo = wholeInfo.replace("<%=description%>", info);
                            StringBuffer buffer = new StringBuffer();
                            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)css);
                            buffer.append(wholeInfo);
                            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
                            wholeInfo = buffer.toString();
                            return wholeInfo;
                        }
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return info;
    }

    private static String getSupportedTypesStirng(List supportedTypes, String type) {
        String imageLine = "";
        String comma = "";
        int i = 0;
        for (Object oneType : supportedTypes) {
            if (!((String)oneType).startsWith(type)) continue;
            if (i != 0) {
                comma = ", ";
            }
            imageLine = String.valueOf(imageLine) + comma + ((String)oneType).substring(type.length());
            ++i;
        }
        boolean noBrowserInfo = VjoCompletionProposal.noBrowserInfo(supportedTypes);
        if (noBrowserInfo) {
            "BrowserType.".equals(type);
        }
        return imageLine;
    }

    private static String getIcon(List supportedTypes) {
        String imageLine = "";
        String path = "";
        try {
            URL url = new URL(Platform.getConfigurationLocation().getURL(), PERS_FOLDER);
            path = url.getPath();
            path = path.substring(1);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        boolean noBrowserInfo = VjoCompletionProposal.noBrowserInfo(supportedTypes);
        if (VjoCompletionProposal.getDescOfSupport(supportedTypes, "FIREFOX").trim().length() > 0 || noBrowserInfo) {
            imageLine = String.valueOf(imageLine) + "<img aligh=\"right\" src=\"" + path + "/firefox.gif\" height=\"25\" width=\"25\" border=\"0\" title=\"" + VjoCompletionProposal.getDescOfSupport(supportedTypes, "MOZILLA") + "\">";
        }
        if (VjoCompletionProposal.getDescOfSupport(supportedTypes, "IE").trim().length() > 0 || noBrowserInfo) {
            imageLine = String.valueOf(imageLine) + "<img aligh=\"right\" src=\"" + path + "/ie.gif\" height=\"25\" width=\"25\" border=\"0\" title=\"" + VjoCompletionProposal.getDescOfSupport(supportedTypes, "IE") + "\">";
        }
        if (VjoCompletionProposal.getDescOfSupport(supportedTypes, "OPERA").trim().length() > 0 || noBrowserInfo) {
            imageLine = String.valueOf(imageLine) + "<img aligh=\"right\" src=\"" + path + "/opera.gif\" height=\"25\" width=\"25\" border=\"0\" title=\"" + VjoCompletionProposal.getDescOfSupport(supportedTypes, "OPERA") + "\">";
        }
        if (VjoCompletionProposal.getDescOfSupport(supportedTypes, "SAFARI").trim().length() > 0 || noBrowserInfo) {
            imageLine = String.valueOf(imageLine) + "<img aligh=\"right\" src=\"" + path + "/safari.gif\" height=\"25\" width=\"25\" border=\"0\" title=\"" + VjoCompletionProposal.getDescOfSupport(supportedTypes, "SAFARI") + "\">";
        }
        if (VjoCompletionProposal.getDescOfSupport(supportedTypes, "CHROME").trim().length() > 0 || noBrowserInfo) {
            imageLine = String.valueOf(imageLine) + "<img aligh=\"right\" src=\"" + path + "/chrome.gif\" height=\"25\" width=\"25\" border=\"0\" title=\"" + VjoCompletionProposal.getDescOfSupport(supportedTypes, "CHROME") + "\">";
        }
        return imageLine;
    }

    private static boolean noBrowserInfo(List supportedTypes) {
        boolean noBrowserInfo = true;
        for (Object type : supportedTypes) {
            if (!((String)type).contains("BrowserType.")) continue;
            noBrowserInfo = false;
            break;
        }
        return noBrowserInfo;
    }

    private static List fillAllSupportedExplorer(Object jstElement, List allSupportedExplorers) {
        if (jstElement instanceof IJstProperty) {
            List annotations = ((IJstProperty)jstElement).getAnnotations();
            VjoCompletionProposal.getExplorerInfoFromAnnotation(allSupportedExplorers, annotations);
            if (annotations.size() == 0) {
                VjoCompletionProposal.fillAllSupportedExplorer(((IJstProperty)jstElement).getOwnerType(), allSupportedExplorers);
            }
        } else if (jstElement instanceof IJstMethod) {
            List annotations = ((IJstMethod)jstElement).getAnnotations();
            VjoCompletionProposal.getExplorerInfoFromAnnotation(allSupportedExplorers, annotations);
            if (annotations.size() == 0) {
                VjoCompletionProposal.fillAllSupportedExplorer(((IJstMethod)jstElement).getOwnerType(), allSupportedExplorers);
            }
        } else if (jstElement instanceof IJstType) {
            List annotations = ((IJstType)jstElement).getAnnotations();
            VjoCompletionProposal.getExplorerInfoFromAnnotation(allSupportedExplorers, annotations);
        }
        return allSupportedExplorers;
    }

    private static void getExplorerInfoFromAnnotation(List allSupportedExplorers, List annotations) {
        VjoProposalAditionalInfoGenerator.getExplorerInfoFromAnnotation(allSupportedExplorers, annotations);
    }

    private static void copyHtmlTemplateFromBundleToTemp() {
        String[] htmlFiles;
        String[] stringArray = htmlFiles = new String[]{PERS_FILENAME};
        int n = htmlFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            VjoCompletionProposal.copyFileFromBundleToTemp("templates", file);
            ++n2;
        }
    }

    private static void copyIconsFromBundleToTemp() {
        String[] icons;
        String[] stringArray = icons = new String[]{"chrome.gif", "firefox.gif", "ie.gif", "opera.gif", "safari.gif"};
        int n = icons.length;
        int n2 = 0;
        while (n2 < n) {
            String icon = stringArray[n2];
            VjoCompletionProposal.copyFileFromBundleToTemp("icons", icon);
            ++n2;
        }
    }

    private static void copyFileFromBundleToTemp(String folderName, String fileName) {
        try {
            Location configLoc = Platform.getConfigurationLocation();
            VjoCompletionProposal.generateTempFolder(new URL(configLoc.getURL(), PERS_FOLDER), true);
            URL url = new URL(configLoc.getURL(), "org.eclipse.vjet.eclipse.ui//" + fileName);
            File persFile = new File(url.getFile());
            if (persFile.exists()) {
                return;
            }
            persFile.createNewFile();
            InputStream stream = VjetUIPlugin.getDefault().getBundle().getEntry("//" + folderName + "//" + fileName).openStream();
            byte[] bs = new byte[stream.available()];
            stream.read(bs);
            FileOutputStream fop = new FileOutputStream(persFile);
            if (persFile.exists()) {
                fop.write(bs);
                fop.flush();
                fop.close();
            }
        }
        catch (IOException iOException) {}
    }

    private static String getDescOfSupport(List<String> supportedTypes, String type) {
        for (String everyType : supportedTypes) {
            if (!everyType.contains(type)) continue;
            return everyType;
        }
        return "";
    }

    private static String translateCharacterToNumber(String desc) {
        if (desc != null) {
            String[] numbers = new String[]{"_ZERO", "_ONE", "_TWO", "_THREE", "_FOUR", "_FIVE", "_SIX", "_SEVEN", "_EIGHT", "_NINE"};
            int i = 0;
            while (i < numbers.length) {
                if (desc.contains(numbers[i])) {
                    desc = desc.replace(numbers[i], String.valueOf(i));
                }
                ++i;
            }
            if (desc.contains("_DOT")) {
                desc = desc.replace("_DOT", ".");
            }
        }
        return desc;
    }

    public static String getElementBriefDesc(IJstProperty property) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(property.getOwnerType().getName()) + "\n");
        buffer.append(String.valueOf(VjoCompletionProposal.getModifierListStr(property.getModifiers())) + " <b>");
        buffer.append(property.getName() + "</b> ");
        return buffer.toString();
    }

    public static String getModifierListStr(JstModifiers jstModifiers) {
        List list = jstModifiers.getChildren();
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            BaseJstNode cfr_ignored_0 = (BaseJstNode)it.next();
            buffer.append("");
        }
        return buffer.toString();
    }

    public static String getElementBriefDesc(IJstMethod method) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(VjoCompletionProposal.getModifierListStr(method.getModifiers())) + " " + method.getRtnType().getName() + " <b>");
        buffer.append(method.getName() + "</b> ");
        buffer.append("(" + VjoCompletionProposal.combineParameters(method) + ")");
        return buffer.toString();
    }

    private static String combineParameters(IJstMethod method) {
        String par = "";
        if (method != null) {
            List args = method.getArgs();
            String comma = "";
            int i = 0;
            for (JstArg arg : args) {
                if (i != 0) {
                    comma = ", ";
                }
                par = String.valueOf(par) + comma + arg.getType().getSimpleName() + " " + arg.getName();
                ++i;
            }
        }
        return par;
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            try {
                reader.close();
            }
            catch (IOException iOException2) {}
            return null;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
        return buf.toString();
    }

    public void apply(IDocument document, char trigger, int offset) {
        super.apply(document, trigger, offset);
        if (this.isTypeProposal()) {
            VjoSourceType type = (VjoSourceType)this.getModelElement();
            IJstType jstType = (IJstType)this.extraInfo;
            MultiTextEdit edit = this.needsRewriter.rewrite(type, jstType);
            this.applyNeeds(document, edit);
        }
    }

    private void applyNeeds(IDocument document, MultiTextEdit edit) {
        int oldLen = document.getLength();
        try {
            edit.apply(document, 2);
            this.setReplacementOffset(this.getReplacementOffset() + document.getLength() - oldLen);
        }
        catch (Exception e) {
            DLTKCore.error((String)e.getMessage(), (Throwable)e);
        }
    }

    private boolean isTypeProposal() {
        return this.getModelElement() instanceof VjoSourceType && this.extraInfo instanceof IJstType;
    }

    public void setExtraInfo(Object extraInfo) {
        this.extraInfo = extraInfo;
    }
}

