/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.mod.internal.ui.text.ScriptElementProvider;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.ScriptElementLabels;
import org.eclipse.dltk.mod.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.mod.ui.text.IColorManager;
import org.eclipse.dltk.mod.ui.text.ScriptOutlineInformationControl;
import org.eclipse.dltk.mod.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.mod.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.mod.ui.text.completion.ContentAssistPreference;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.vjet.eclipse.core.IJSSourceModule;
import org.eclipse.vjet.eclipse.internal.ui.text.CommentFormattingStrategy;
import org.eclipse.vjet.eclipse.internal.ui.text.JavaScriptFormattingStrategy;
import org.eclipse.vjet.eclipse.internal.ui.text.JavascriptCodeScanner;
import org.eclipse.vjet.eclipse.internal.ui.text.JavascriptStringScanner;
import org.eclipse.vjet.eclipse.internal.ui.text.VjoAutoEditStrategy;
import org.eclipse.vjet.eclipse.internal.ui.text.VjoCodeScanner;
import org.eclipse.vjet.eclipse.internal.ui.text.VjoCommentScanner;
import org.eclipse.vjet.eclipse.internal.ui.text.VjoDocAutoIndentStrategy;
import org.eclipse.vjet.eclipse.internal.ui.text.VjoDoubleClickSelector;
import org.eclipse.vjet.eclipse.internal.ui.text.VjoJavaDocScanner;
import org.eclipse.vjet.eclipse.internal.ui.text.VjoTextTools;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.JavaScriptContentAssistPreference;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.VjoCompletionProcessor;
import org.eclipse.vjet.eclipse.internal.ui.typehierarchy.VjoHierarchyInformationControl;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;
import org.eclipse.vjet.eclipse.ui.viewsupport.VjoLabelProvider;

public class VjoSourceViewerConfiguration
extends ScriptSourceViewerConfiguration {
    private JavascriptCodeScanner m_codeScanner;
    private AbstractScriptScanner m_single_commentScanner;
    private AbstractScriptScanner m_multi_commentScanner;
    private AbstractScriptScanner m_stringScanner;
    private VjoTextTools m_textTools;
    private VjoJavaDocScanner mJavaDocScanner;
    private VjoDoubleClickSelector fVjoDoubleClickSelector;

    public void setModule(ISourceModule module) {
        if (this.m_codeScanner instanceof VjoCodeScanner) {
            VjoCodeScanner s = (VjoCodeScanner)this.m_codeScanner;
            s.setModule(module);
        }
    }

    public VjoSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(colorManager, preferenceStore, editor, partitioning);
    }

    protected void alterContentAssistant(ContentAssistant assistant) {
        VjoCompletionProcessor scriptProcessor = new VjoCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)scriptProcessor, "__dftl_partition_content_type");
        VjoCompletionProcessor singleLineProcessor = new VjoCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__javascript_single_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)singleLineProcessor, "__javascript_single_comment");
        VjoCompletionProcessor multiLineProcessor = new VjoCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__javascript_multi_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)multiLineProcessor, "__javascript_multi_comment");
        VjoCompletionProcessor stringProcessor = new VjoCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__javascript_string");
        assistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__javascript_string");
    }

    protected ContentAssistPreference getContentAssistPreference() {
        return JavaScriptContentAssistPreference.getDefault();
    }

    public IInformationPresenter getOutlinePresenter(ScriptSourceViewer sourceViewer, boolean doCodeResolve) {
        IInformationPresenter informationPresenter = super.getOutlinePresenter(sourceViewer, doCodeResolve);
        IInformationProvider informationProvider = informationPresenter.getInformationProvider("__dftl_partition_content_type");
        ((InformationPresenter)informationPresenter).setInformationProvider(informationProvider, "__javascript_single_comment");
        ((InformationPresenter)informationPresenter).setInformationProvider(informationProvider, "__javascript_multi_comment");
        ((InformationPresenter)informationPresenter).setInformationProvider(informationProvider, "__dftl_partition_content_type");
        ((InformationPresenter)informationPresenter).setInformationProvider(informationProvider, "__javascript_doc");
        ((InformationPresenter)informationPresenter).setInformationProvider(informationProvider, "__javascript_string");
        ((InformationPresenter)informationPresenter).setInformationProvider(informationProvider, "__javascript_partitioning");
        return informationPresenter;
    }

    public IInformationPresenter getHierarchyPresenter(ScriptSourceViewer sourceViewer, boolean doCodeResolve) {
        if (this.getEditor() != null && this.getEditor().getEditorInput() != null && DLTKUIPlugin.getEditorInputModelElement((IEditorInput)this.getEditor().getEditorInput()) == null) {
            return null;
        }
        InformationPresenter presenter = new InformationPresenter(this.getHierarchyPresenterControlCreator((ISourceViewer)sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning((ISourceViewer)sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        ScriptElementProvider provider = new ScriptElementProvider((IEditorPart)this.getEditor(), doCodeResolve){

            public Object getInformation2(ITextViewer textViewer, IRegion subject) {
                Object el = super.getInformation2(textViewer, subject);
                if (el instanceof IJSSourceModule) {
                    try {
                        IType[] types = ((IJSSourceModule)el).getAllTypes();
                        if (types != null && types.length > 0) {
                            el = types[0];
                        }
                    }
                    catch (ModelException e) {
                        e.printStackTrace();
                    }
                }
                return el;
            }
        };
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__javascript_doc");
        presenter.setInformationProvider((IInformationProvider)provider, "__javascript_single_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__javascript_multi_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__javascript_string");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    private IInformationControlCreator getHierarchyPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new VjoHierarchyInformationControl(parent, shellStyle, treeStyle){

                    @Override
                    protected IPreferenceStore getPreferenceStore() {
                        return VjetUIPlugin.getDefault().getPreferenceStore();
                    }
                };
            }
        };
    }

    protected IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, final String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new ScriptOutlineInformationControl(parent, shellStyle, treeStyle, commandId){

                    protected IPreferenceStore getPreferenceStore() {
                        return VjetUIPlugin.getDefault().getPreferenceStore();
                    }

                    protected ScriptOutlineInformationControl.OutlineLabelProvider getLabelProvider() {
                        long txtFlags = 0x201000000402BL | ScriptElementLabels.ALL_CATEGORY;
                        int imgFlags = 1;
                        VjoLabelProvider vjoLabelProvider = new VjoLabelProvider(txtFlags, imgFlags, VjoSourceViewerConfiguration.this.fPreferenceStore);
                        return new QuickOutlineVJOLabelProvider(vjoLabelProvider);
                    }

                    class QuickOutlineVJOLabelProvider
                    extends ScriptOutlineInformationControl.OutlineLabelProvider {
                        VjoLabelProvider vjoLabelProvider;

                        public QuickOutlineVJOLabelProvider(VjoLabelProvider vjoLabelProvider) {
                            super((ScriptOutlineInformationControl)this);
                            this.vjoLabelProvider = null;
                            this.vjoLabelProvider = vjoLabelProvider;
                        }

                        public String getText(Object element) {
                            String text = this.vjoLabelProvider.getText(element);
                            this.vjoLabelProvider.setTextFlags(this.getTextFlags());
                            if (this.isShowDefiningType()) {
                                try {
                                    IType type = this.getDefiningType(element);
                                    if (type != null) {
                                        StringBuffer buf = new StringBuffer(this.vjoLabelProvider.getText(type));
                                        buf.append(" - ");
                                        buf.append(text);
                                        return buf.toString();
                                    }
                                }
                                catch (ModelException modelException) {}
                            }
                            return text;
                        }
                    }
                };
            }
        };
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        ScriptPresentationReconciler reconciler = new ScriptPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.m_codeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.mJavaDocScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_doc");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_doc");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.m_single_commentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_single_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_single_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.m_multi_commentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_multi_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_multi_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.m_stringScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_string");
        return reconciler;
    }

    protected void initializeScanners() {
        Assert.isTrue((boolean)this.isNewSetup());
        this.m_codeScanner = new VjoCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.m_stringScanner = new JavascriptStringScanner(this.getColorManager(), this.fPreferenceStore);
        this.m_single_commentScanner = new VjoCommentScanner(this.getColorManager(), this.fPreferenceStore, "VJET_single_line_comment");
        this.m_multi_commentScanner = new VjoCommentScanner(this.getColorManager(), this.fPreferenceStore, "VJET_multi_line_comment");
        this.mJavaDocScanner = new VjoJavaDocScanner(this.getColorManager(), this.fPreferenceStore);
    }

    private boolean isNewSetup() {
        return this.m_textTools == null;
    }

    protected String getCommentPrefix() {
        return "//";
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__javascript_string", "__javascript_single_comment", "__javascript_multi_comment", "__javascript_doc"};
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.m_codeScanner.affectsBehavior(event) || this.m_stringScanner.affectsBehavior(event) || this.m_single_commentScanner.affectsBehavior(event) || this.m_multi_commentScanner.affectsBehavior(event) || this.mJavaDocScanner.affectsBehavior(event);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        Assert.isTrue((boolean)this.isNewSetup());
        if (this.m_codeScanner.affectsBehavior(event)) {
            this.m_codeScanner.adaptToPreferenceChange(event);
        }
        if (this.m_stringScanner.affectsBehavior(event)) {
            this.m_stringScanner.adaptToPreferenceChange(event);
        }
        if (this.m_single_commentScanner.affectsBehavior(event)) {
            this.m_single_commentScanner.adaptToPreferenceChange(event);
        }
        if (this.m_multi_commentScanner.affectsBehavior(event)) {
            this.m_multi_commentScanner.adaptToPreferenceChange(event);
        }
        if (this.mJavaDocScanner.affectsBehavior(event)) {
            this.mJavaDocScanner.adaptToPreferenceChange(event);
        }
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        String partitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        if ("__javascript_doc".equals(contentType) || "__javascript_multi_comment".equals(contentType)) {
            return new IAutoEditStrategy[]{new VjoDocAutoIndentStrategy(partitioning)};
        }
        return new IAutoEditStrategy[]{new VjoAutoEditStrategy(partitioning, null)};
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getTabWidth(sourceViewer);
        }
        return this.fPreferenceStore.getInt("formatter.tabulation.size");
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fVjoDoubleClickSelector == null) {
            this.fVjoDoubleClickSelector = new VjoDoubleClickSelector();
        }
        return this.fVjoDoubleClickSelector;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        formatter.setMasterStrategy((IFormattingStrategy)new JavaScriptFormattingStrategy());
        formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__javascript_doc");
        formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__javascript_single_comment");
        formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__javascript_multi_comment");
        return formatter;
    }
}

