/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.preferences.formatting;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.internal.ui.preferences.PreferencesAccess;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.FormatterProfileManager;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.IProfileVersioner;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.ProfileManager;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.ProfileStore;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.ProfileVersioner;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.xml.sax.InputSource;

public class FormatterProfileStore
extends ProfileStore {
    private static final String PREF_FORMATTER_PROFILES = "org.eclipse.vjet.ui.formatterprofiles";
    private final IProfileVersioner fProfileVersioner;

    public FormatterProfileStore(IProfileVersioner profileVersioner) {
        super(PREF_FORMATTER_PROFILES, profileVersioner);
        this.fProfileVersioner = profileVersioner;
    }

    @Override
    public List readProfiles(IScopeContext scope) throws CoreException {
        List profiles = super.readProfiles(scope);
        if (profiles == null) {
            profiles = this.readOldForCompatibility(scope);
        }
        return profiles;
    }

    private List readOldForCompatibility(IScopeContext instanceScope) {
        block9: {
            List list;
            File file = VjetPlugin.getDefault().getStateLocation().append("code_formatter_profiles.xml").toFile();
            if (!file.exists()) {
                return null;
            }
            FileReader reader = new FileReader(file);
            try {
                List res = FormatterProfileStore.readProfilesFromStream(new InputSource(reader));
                if (res != null) {
                    int i = 0;
                    while (i < res.size()) {
                        this.fProfileVersioner.update((ProfileManager.CustomProfile)res.get(i));
                        ++i;
                    }
                    this.writeProfiles(res, instanceScope);
                }
                file.delete();
                list = res;
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (CoreException e) {
                    VjetUIPlugin.log((Exception)((Object)e));
                    break block9;
                }
                catch (IOException e) {
                    VjetUIPlugin.log(e);
                }
            }
            reader.close();
            return list;
        }
        return null;
    }

    public static void checkCurrentOptionsVersion() {
        PreferencesAccess access = PreferencesAccess.getOriginalPreferences();
        ProfileVersioner profileVersioner = new ProfileVersioner();
        IScopeContext instanceScope = access.getInstanceScope();
        IEclipsePreferences uiPreferences = instanceScope.getNode("org.eclipse.vjet.eclipse.ui");
        int version = uiPreferences.getInt("org.eclipse.vjet.ui.formatterprofiles.version", 0);
        if (version >= profileVersioner.getCurrentVersion()) {
            return;
        }
        try {
            ArrayList profiles = new FormatterProfileStore(profileVersioner).readProfiles(instanceScope);
            if (profiles == null) {
                profiles = new ArrayList();
            }
            FormatterProfileManager manager = new FormatterProfileManager(profiles, instanceScope, access, profileVersioner);
            manager.commitChanges(instanceScope);
            uiPreferences.putInt("org.eclipse.vjet.ui.formatterprofiles.version", profileVersioner.getCurrentVersion());
            FormatterProfileStore.savePreferences(instanceScope);
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IScopeContext scope = access.getProjectScope(projects[i]);
                if (manager.hasProjectSpecificSettings(scope)) {
                    manager = new FormatterProfileManager(profiles, scope, access, profileVersioner);
                    manager.commitChanges(scope);
                    FormatterProfileStore.savePreferences(scope);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            VjetUIPlugin.log((Exception)((Object)e));
        }
        catch (BackingStoreException e) {
            VjetUIPlugin.log((Exception)((Object)e));
        }
    }

    private static void savePreferences(IScopeContext context) throws BackingStoreException {
        try {
            context.getNode("org.eclipse.vjet.eclipse.ui").flush();
        }
        finally {
            context.getNode("org.eclipse.vjet.eclipse.core").flush();
        }
    }
}

