/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.editor;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.ElementChangedEvent;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IElementChangedListener;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelElementDelta;
import org.eclipse.dltk.mod.core.IPackageDeclaration;
import org.eclipse.dltk.mod.core.IParent;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ISourceReference;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.ScriptModelUtil;
import org.eclipse.dltk.mod.internal.core.AbstractSourceModule;
import org.eclipse.dltk.mod.internal.core.JSSourceMethod;
import org.eclipse.dltk.mod.internal.ui.actions.AbstractToggleLinkingAction;
import org.eclipse.dltk.mod.internal.ui.actions.CCPActionGroup;
import org.eclipse.dltk.mod.internal.ui.actions.CompositeActionGroup;
import org.eclipse.dltk.mod.internal.ui.dnd.DLTKViewerDragSupport;
import org.eclipse.dltk.mod.internal.ui.dnd.DLTKViewerDropSupport;
import org.eclipse.dltk.mod.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptOutlinePage;
import org.eclipse.dltk.mod.internal.ui.editor.TogglePresentationAction;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.MembersOrderPreferenceCache;
import org.eclipse.dltk.mod.ui.ModelElementSorter;
import org.eclipse.dltk.mod.ui.ScriptElementLabels;
import org.eclipse.dltk.mod.ui.actions.CustomFiltersActionGroup;
import org.eclipse.dltk.mod.ui.actions.GenerateActionGroup;
import org.eclipse.dltk.mod.ui.actions.MemberFilterActionGroup;
import org.eclipse.dltk.mod.ui.actions.OpenViewActionGroup;
import org.eclipse.dltk.mod.ui.actions.SearchActionGroup;
import org.eclipse.dltk.mod.ui.viewsupport.AbstractModelElementFilter;
import org.eclipse.dltk.mod.ui.viewsupport.DecoratingModelLabelProvider;
import org.eclipse.dltk.mod.ui.viewsupport.MemberFilterAction;
import org.eclipse.dltk.mod.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.dltk.mod.ui.viewsupport.SourcePositionSorter;
import org.eclipse.dltk.mod.ui.viewsupport.StatusBarUpdater;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.vjet.eclipse.internal.ui.editor.ActionMessages;
import org.eclipse.vjet.eclipse.internal.ui.editor.VjoEditor;
import org.eclipse.vjet.eclipse.internal.ui.filters.FieldsFilter;
import org.eclipse.vjet.eclipse.internal.ui.filters.LocalTypesFilter;
import org.eclipse.vjet.eclipse.internal.ui.filters.NonPublicFilter;
import org.eclipse.vjet.eclipse.internal.ui.filters.StaticsFilter;
import org.eclipse.vjet.eclipse.ui.viewsupport.VjoLabelProvider;
import org.eclipse.vjet.eclipse.ui.viewsupport.VjoSourcePositionSorter;

public class VjoOutlinePage
extends ScriptOutlinePage {
    private boolean fTopLevelTypeOnly;
    static Object[] NO_CHILDREN = new Object[0];
    private CompositeActionGroup fActionGroups;
    private Hashtable fActions = new Hashtable();
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    private DLTKViewerDropSupport fDropSupport;
    private VjoEditor fEditor;
    private IModelElement fInput;
    private Menu fMenu;
    private ListenerList fPostSelectionChangedListeners = new ListenerList(1);
    private IPropertyChangeListener fPropertyChangeListener;
    private ListenerList fSelectionChangedListeners = new ListenerList(1);
    protected IPreferenceStore fStore;
    private ToggleLinkingAction fToggleLinkingAction;
    private TogglePresentationAction fTogglePresentation;

    public VjoOutlinePage(VjoEditor editor, IPreferenceStore store) {
        super((ScriptEditor)editor, store);
        Assert.isNotNull((Object)((Object)editor));
        this.fEditor = editor;
        this.fStore = store;
        this.fTogglePresentation = new TogglePresentationAction();
        this.fTogglePresentation.setEditor((ITextEditor)editor);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                VjoOutlinePage.this.doPropertyChange(event);
            }
        };
        this.fStore.addPropertyChangeListener(this.fPropertyChangeListener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.addPostSelectionChangedListener(listener);
        } else {
            this.fPostSelectionChangedListeners.add((Object)listener);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.addSelectionChangedListener(listener);
        } else {
            this.fSelectionChangedListeners.add((Object)listener);
        }
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        if (menu.isEmpty()) {
            menu.add((IContributionItem)new GroupMarker("group.goto"));
            menu.add((IContributionItem)new Separator("group.open"));
            menu.add((IContributionItem)new GroupMarker("group.show"));
            menu.add((IContributionItem)new Separator("group.edit"));
            menu.add((IContributionItem)new Separator("group.reorganize"));
            menu.add((IContributionItem)new Separator("group.search"));
            menu.add((IContributionItem)new Separator("group.properties"));
        }
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        this.fActionGroups.setContext(new ActionContext((ISelection)selection));
        this.fActionGroups.fillContextMenu(menu);
    }

    public void createControl(Composite parent) {
        Tree tree = new Tree(parent, 2);
        VjoLabelProvider lprovider = new VjoLabelProvider(0x201000000402BL | ScriptElementLabels.ALL_CATEGORY, 1, this.fStore);
        ILabelDecorator ldecorator = this.getLabelDecorator();
        if (ldecorator != null) {
            lprovider.addLabelDecorator(ldecorator);
        }
        this.fOutlineViewer = new ScriptOutlinePage.ScriptOutlineViewer(this, tree){

            public void reconcile(IModelElementDelta delta) {
                if (this.getComparator() == null && VjoOutlinePage.this.fTopLevelTypeOnly && delta.getElement() instanceof IType && (delta.getKind() & 1) != 0) {
                    this.refresh(true);
                    return;
                }
                super.reconcile(delta);
            }
        };
        this.initDragAndDrop();
        this.fOutlineViewer.setContentProvider((IContentProvider)new ChildrenProvider());
        this.fOutlineViewer.setLabelProvider((IBaseLabelProvider)new DecoratingModelLabelProvider((ScriptUILabelProvider)lprovider));
        Object[] listeners = this.fSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            this.fSelectionChangedListeners.remove(listeners[i]);
            this.fOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)listeners[i]);
            ++i;
        }
        listeners = this.fPostSelectionChangedListeners.getListeners();
        i = 0;
        while (i < listeners.length) {
            this.fPostSelectionChangedListeners.remove(listeners[i]);
            this.fOutlineViewer.addPostSelectionChangedListener((ISelectionChangedListener)listeners[i]);
            ++i;
        }
        String contextMenuId = String.valueOf(DLTKUIPlugin.getPluginId()) + ".outline";
        MenuManager manager = new MenuManager(contextMenuId, contextMenuId);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                VjoOutlinePage.this.contextMenuAboutToShow(m);
            }
        });
        this.fMenu = manager.createContextMenu((Control)tree);
        tree.setMenu(this.fMenu);
        IPageSite site = this.getSite();
        site.registerContextMenu(contextMenuId, manager, (ISelectionProvider)this.fOutlineViewer);
        this.updateSelectionProvider(site);
        IDLTKLanguageToolkit toolkit = this.fEditor.getLanguageToolkit();
        this.fActionGroups = new CompositeActionGroup(new ActionGroup[]{new OpenViewActionGroup((Page)this), new CCPActionGroup((Page)this), new GenerateActionGroup((Page)this, "group.show"), new SearchActionGroup((Page)this, toolkit)});
        IActionBars actionBars = site.getActionBars();
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, this.fEditor.getAction(ITextEditorActionConstants.UNDO));
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, this.fEditor.getAction(ITextEditorActionConstants.REDO));
        IAction action = this.fEditor.getAction(ITextEditorActionConstants.NEXT);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.NEXT, action);
        action = this.fEditor.getAction(ITextEditorActionConstants.PREVIOUS);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.PREVIOUS, action);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.fTogglePresentation);
        this.fActionGroups.fillActionBars(actionBars);
        IStatusLineManager statusLineManager = actionBars.getStatusLineManager();
        if (statusLineManager != null) {
            StatusBarUpdater updater = new StatusBarUpdater(statusLineManager);
            this.fOutlineViewer.addPostSelectionChangedListener((ISelectionChangedListener)updater);
        }
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup("org.eclipse.dltk.mod.ui.ScriptOutlinePage", (StructuredViewer)this.fOutlineViewer);
        this.registerToolbarActions(actionBars);
        this.fOutlineViewer.setInput((Object)this.fInput);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.vjet.eclipse.ui.show_vjet_outline_action");
    }

    public void dispose() {
        if (this.fEditor == null) {
            return;
        }
        if (this.fCustomFiltersActionGroup != null) {
            this.fCustomFiltersActionGroup.dispose();
            this.fCustomFiltersActionGroup = null;
        }
        this.fEditor.outlinePageClosed();
        this.fEditor = null;
        this.fSelectionChangedListeners.clear();
        this.fSelectionChangedListeners = null;
        this.fPostSelectionChangedListeners.clear();
        this.fPostSelectionChangedListeners = null;
        if (this.fPropertyChangeListener != null) {
            this.fStore.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        this.fTogglePresentation.setEditor(null);
        this.fOutlineViewer = null;
        super.dispose();
    }

    private void doPropertyChange(PropertyChangeEvent event) {
        if (this.fOutlineViewer != null && MembersOrderPreferenceCache.isMemberOrderProperty((String)event.getProperty())) {
            this.fOutlineViewer.refresh(false);
        }
    }

    public IAction getAction(String actionID) {
        Assert.isNotNull((Object)actionID);
        return (IAction)this.fActions.get(actionID);
    }

    public Object getAdapter(Class key) {
        if (key == IShowInSource.class) {
            return this.getShowInSource();
        }
        if (key == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.dltk.mod.ui.ScriptExplorer"};
                }
            };
        }
        if (key == IShowInTarget.class) {
            return this.getShowInTarget();
        }
        return null;
    }

    public Control getControl() {
        if (this.fOutlineViewer != null) {
            return this.fOutlineViewer.getControl();
        }
        return null;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, VjoOutlinePage.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    protected IShowInTarget getShowInTarget() {
        return new IShowInTarget(){

            public boolean show(ShowInContext context) {
                ISelection sel = context.getSelection();
                if (sel instanceof ITextSelection) {
                    ITextSelection tsel = (ITextSelection)sel;
                    int offset = tsel.getOffset();
                    IModelElement element = VjoOutlinePage.this.fEditor.getElementAt(offset);
                    if (element != null) {
                        VjoOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)element));
                        return true;
                    }
                } else if (sel instanceof IStructuredSelection) {
                    VjoOutlinePage.this.setSelection(sel);
                    return true;
                }
                return false;
            }
        };
    }

    private void initDragAndDrop() {
        this.fDropSupport = new DLTKViewerDropSupport((StructuredViewer)this.fOutlineViewer);
        this.fDropSupport.start();
        new DLTKViewerDragSupport((StructuredViewer)this.fOutlineViewer).start();
    }

    protected void registerSpecialToolbarActions(IActionBars actionBars) {
        ArrayList<MemberFilterAction> actions = new ArrayList<MemberFilterAction>(5);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        MemberFilterActionGroup fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)this.fOutlineViewer, this.fStore);
        String title = ActionMessages.MemberFilterActionGroup_hide_variables_label;
        String helpContext = "";
        MemberFilterAction hideVariables = new MemberFilterAction(fMemberFilterActionGroup, title, (AbstractModelElementFilter)new FieldsFilter(), helpContext, true);
        hideVariables.setDescription(ActionMessages.MemberFilterActionGroup_hide_variables_description);
        hideVariables.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_variables_tooltip);
        DLTKPluginImages.setLocalImageDescriptors((IAction)hideVariables, (String)"fields_co.gif");
        actions.add(hideVariables);
        title = ActionMessages.MemberFilterActionGroup_hide_static_label;
        helpContext = "";
        MemberFilterAction hideStatic = new MemberFilterAction(fMemberFilterActionGroup, title, (AbstractModelElementFilter)new StaticsFilter(), helpContext, true);
        hideStatic.setDescription(ActionMessages.MemberFilterActionGroup_hide_static_description);
        hideStatic.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_static_tooltip);
        DLTKPluginImages.setLocalImageDescriptors((IAction)hideStatic, (String)"static_co.gif");
        actions.add(hideStatic);
        title = ActionMessages.MemberFilterActionGroup_hide_nonpublic_label;
        helpContext = "";
        MemberFilterAction hideNonPublic = new MemberFilterAction(fMemberFilterActionGroup, title, (AbstractModelElementFilter)new NonPublicFilter(), helpContext, true);
        hideNonPublic.setDescription(ActionMessages.MemberFilterActionGroup_hide_nonpublic_description);
        hideNonPublic.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_nonpublic_tooltip);
        DLTKPluginImages.setLocalImageDescriptors((IAction)hideNonPublic, (String)"public_co.gif");
        actions.add(hideNonPublic);
        title = ActionMessages.MemberFilterActionGroup_hide_localtypes_label;
        helpContext = "";
        MemberFilterAction hideLocalType = new MemberFilterAction(fMemberFilterActionGroup, title, (AbstractModelElementFilter)new LocalTypesFilter(), helpContext, true);
        hideLocalType.setDescription(ActionMessages.MemberFilterActionGroup_hide_localtypes_description);
        hideLocalType.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_localtypes_tooltip);
        DLTKPluginImages.setLocalImageDescriptors((IAction)hideLocalType, (String)"localtypes_co.gif");
        actions.add(hideLocalType);
        MemberFilterAction[] fFilterActions = actions.toArray(new MemberFilterAction[actions.size()]);
        fMemberFilterActionGroup.setActions(fFilterActions);
        fMemberFilterActionGroup.contributeToToolBar(toolBarManager);
    }

    private void registerToolbarActions(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)new LexicalSortingAction());
        this.registerSpecialToolbarActions(actionBars);
        this.fCustomFiltersActionGroup.fillActionBars(actionBars);
        IMenuManager viewMenuManager = actionBars.getMenuManager();
        viewMenuManager.add((IContributionItem)new Separator("EndFilterGroup"));
        this.fToggleLinkingAction = new ToggleLinkingAction(this);
        viewMenuManager.add((IAction)new ClassOnlyAction());
        viewMenuManager.add((IAction)this.fToggleLinkingAction);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.removePostSelectionChangedListener(listener);
        } else {
            this.fPostSelectionChangedListeners.remove((Object)listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.removeSelectionChangedListener(listener);
        } else {
            this.fSelectionChangedListeners.remove((Object)listener);
        }
    }

    public void select(ISourceReference reference) {
        IStructuredSelection ss;
        List elements;
        ISelection s;
        if (this.fOutlineViewer != null && (s = this.fOutlineViewer.getSelection()) instanceof IStructuredSelection && !(elements = (ss = (IStructuredSelection)s).toList()).contains(reference)) {
            s = reference == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)reference);
            this.fOutlineViewer.setSelection(s, true);
        }
    }

    public void setAction(String actionID, IAction action) {
        Assert.isNotNull((Object)actionID);
        if (action == null) {
            this.fActions.remove(actionID);
        } else {
            this.fActions.put(actionID, action);
        }
    }

    public void setInput(IModelElement inputElement) {
        this.fInput = inputElement;
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.setInput((Object)this.fInput);
            this.updateSelectionProvider(this.getSite());
        }
    }

    private void updateSelectionProvider(IPageSite site) {
        ISourceModule cu;
        Object provider = this.fOutlineViewer;
        if (this.fInput != null && (cu = (ISourceModule)this.fInput.getAncestor(5)) != null && !ScriptModelUtil.isPrimary((ISourceModule)cu)) {
            provider = new EmptySelectionProvider();
        }
        site.setSelectionProvider((ISelectionProvider)provider);
    }

    protected class ChildrenProvider
    implements ITreeContentProvider {
        private Object[] NO_CLASS = new Object[]{new NoClassElement()};
        private ElementChangedListener fListener;

        protected ChildrenProvider() {
        }

        public void dispose() {
            if (this.fListener != null) {
                DLTKCore.removeElementChangedListener((IElementChangedListener)this.fListener);
                this.fListener = null;
            }
        }

        protected IModelElement[] filter(IModelElement[] children) {
            boolean initializers = false;
            int i = 0;
            while (i < children.length) {
                if (this.matches(children[i])) {
                    initializers = true;
                    break;
                }
                ++i;
            }
            if (!initializers) {
                return children;
            }
            Vector<IModelElement> v = new Vector<IModelElement>();
            int i2 = 0;
            while (i2 < children.length) {
                if (!this.matches(children[i2])) {
                    v.addElement(children[i2]);
                }
                ++i2;
            }
            Object[] result = new IModelElement[v.size()];
            v.copyInto(result);
            return result;
        }

        public Object[] getChildren(Object parent) {
            block3: {
                if (parent instanceof IParent) {
                    IParent c = (IParent)parent;
                    try {
                        return this.filter(c.getChildren());
                    }
                    catch (ModelException x) {
                        if (!DLTKCore.DEBUG && x.isDoesNotExist()) break block3;
                        DLTKUIPlugin.log((Throwable)x);
                    }
                }
            }
            return NO_CHILDREN;
        }

        public Object[] getElements(Object parent) {
            if (VjoOutlinePage.this.fTopLevelTypeOnly && parent instanceof AbstractSourceModule) {
                try {
                    IType[] types = ((AbstractSourceModule)parent).getTypes();
                    if (types.length > 0 && types[0] instanceof IType) {
                        return types[0] != null ? types[0].getChildren() : this.NO_CLASS;
                    }
                }
                catch (Exception e) {
                    JavaPlugin.log((Throwable)e);
                }
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof IModelElement) {
                IModelElement e = (IModelElement)child;
                return e.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object parent) {
            block3: {
                if (parent instanceof IParent) {
                    IParent c = (IParent)parent;
                    try {
                        IModelElement[] children = this.filter(c.getChildren());
                        return children != null && children.length > 0;
                    }
                    catch (ModelException x) {
                        if (!DLTKUIPlugin.isDebug() && x.isDoesNotExist()) break block3;
                        DLTKUIPlugin.log((Throwable)x);
                    }
                }
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            boolean isCU = newInput instanceof ISourceModule;
            if (isCU && this.fListener == null) {
                this.fListener = new ElementChangedListener();
                DLTKCore.addElementChangedListener((IElementChangedListener)this.fListener);
            } else if (!isCU && this.fListener != null) {
                DLTKCore.removeElementChangedListener((IElementChangedListener)this.fListener);
                this.fListener = null;
            }
        }

        public boolean isDeleted(Object o) {
            return false;
        }

        protected boolean matches(IModelElement element) {
            if (element.getElementType() == 9) {
                String name = element.getElementName();
                return name != null && name.indexOf(60) >= 0;
            }
            if (element.getElementType() == 8 && element.getParent() instanceof JSSourceMethod) {
                return true;
            }
            if (element.getElementType() == 10) {
                IPackageDeclaration pkg = (IPackageDeclaration)element;
                return pkg.getElementName().length() == 0;
            }
            return false;
        }
    }

    class ClassOnlyAction
    extends Action {
        public ClassOnlyAction() {
            this.setText(DLTKEditorMessages.VJOOutlinePage_GoIntoTopLevelType_label);
            this.setToolTipText(DLTKEditorMessages.VJOOutlinePage_GoIntoTopLevelType_tooltip);
            this.setDescription(DLTKEditorMessages.VJOOutlinePage_GoIntoTopLevelType_description);
            DLTKPluginImages.setLocalImageDescriptors((IAction)this, (String)"gointo_toplevel_type.gif");
            IPreferenceStore preferenceStore = DLTKUIPlugin.getDefault().getPreferenceStore();
            boolean showclass = preferenceStore.getBoolean("GoIntoTopLevelTypeAction.isChecked");
            this.setTopLevelTypeOnly(showclass);
        }

        public void run() {
            this.setTopLevelTypeOnly(!VjoOutlinePage.this.fTopLevelTypeOnly);
        }

        private void setTopLevelTypeOnly(boolean show) {
            VjoOutlinePage.this.fTopLevelTypeOnly = show;
            this.setChecked(show);
            VjoOutlinePage.this.fOutlineViewer.refresh(false);
            IPreferenceStore preferenceStore = DLTKUIPlugin.getDefault().getPreferenceStore();
            preferenceStore.setValue("GoIntoTopLevelTypeAction.isChecked", show);
        }
    }

    protected class ElementChangedListener
    implements IElementChangedListener {
        protected ElementChangedListener() {
        }

        public void elementChanged(final ElementChangedEvent e) {
            if (VjoOutlinePage.this.getControl() == null) {
                return;
            }
            Display d = VjoOutlinePage.this.getControl().getDisplay();
            if (d != null) {
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IModelElementDelta delta;
                        ISourceModule cu;
                        ISourceModule base = cu = (ISourceModule)VjoOutlinePage.this.fInput;
                        if (VjoOutlinePage.this.fTopLevelTypeOnly) {
                            try {
                                base = cu.getTypes().length > 0 ? cu.getTypes()[0] : null;
                            }
                            catch (ModelException modelException) {}
                            if (base == null) {
                                if (VjoOutlinePage.this.fOutlineViewer != null) {
                                    VjoOutlinePage.this.fOutlineViewer.refresh(true);
                                }
                                return;
                            }
                        }
                        if ((delta = ElementChangedListener.this.findElement((IModelElement)base, e.getDelta())) != null && VjoOutlinePage.this.fOutlineViewer != null) {
                            VjoOutlinePage.this.fOutlineViewer.reconcile(delta);
                        }
                    }
                });
            }
        }

        protected IModelElementDelta findElement(IModelElement unit, IModelElementDelta delta) {
            if (delta == null || unit == null) {
                return null;
            }
            IModelElement element = delta.getElement();
            if (unit.equals(element)) {
                if (this.isPossibleStructuralChange(delta)) {
                    return delta;
                }
                return null;
            }
            if (element.getElementType() > 5) {
                return null;
            }
            IModelElementDelta[] children = delta.getAffectedChildren();
            if (children == null || children.length == 0) {
                return null;
            }
            int i = 0;
            while (i < children.length) {
                IModelElementDelta d = this.findElement(unit, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }

        private boolean isPossibleStructuralChange(IModelElementDelta cuDelta) {
            if (cuDelta.getKind() != 4) {
                return true;
            }
            int flags = cuDelta.getFlags();
            if ((flags & 8) != 0) {
                return true;
            }
            return (flags & 0x4001) == 1;
        }
    }

    private static final class EmptySelectionProvider
    implements ISelectionProvider {
        private EmptySelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }

    class LexicalSortingAction
    extends Action {
        private ModelElementSorter fComparator = new ModelElementSorter();
        private SourcePositionSorter fSourcePositonComparator = new VjoSourcePositionSorter();

        public LexicalSortingAction() {
            this.setText(DLTKEditorMessages.ScriptOutlinePage_Sort_label);
            DLTKPluginImages.setLocalImageDescriptors((IAction)this, (String)"alphab_sort_co.gif");
            this.setToolTipText(DLTKEditorMessages.ScriptOutlinePage_Sort_tooltip);
            this.setDescription(DLTKEditorMessages.ScriptOutlinePage_Sort_description);
            boolean checked = VjoOutlinePage.this.fStore.getBoolean("LexicalSortingAction.isChecked");
            this.valueChanged(checked, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(final boolean on, boolean store) {
            this.setChecked(on);
            BusyIndicator.showWhile((Display)VjoOutlinePage.this.fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (on) {
                        VjoOutlinePage.this.fOutlineViewer.setComparator((ViewerComparator)LexicalSortingAction.this.fComparator);
                        VjoOutlinePage.this.fDropSupport.setFeedbackEnabled(false);
                    } else {
                        VjoOutlinePage.this.fOutlineViewer.setComparator((ViewerComparator)LexicalSortingAction.this.fSourcePositonComparator);
                        VjoOutlinePage.this.fDropSupport.setFeedbackEnabled(true);
                    }
                }
            });
            if (store) {
                DLTKUIPlugin.getDefault().getPreferenceStore().setValue("LexicalSortingAction.isChecked", on);
            }
        }
    }

    static class NoClassElement
    extends WorkbenchAdapter
    implements IAdaptable {
        NoClassElement() {
        }

        public Object getAdapter(Class clas) {
            if (clas == IWorkbenchAdapter.class) {
                return this;
            }
            return null;
        }

        public String toString() {
            return DLTKEditorMessages.ScriptOutlinePage_error_NoTopLevelType;
        }
    }

    public class ToggleLinkingAction
    extends AbstractToggleLinkingAction {
        VjoOutlinePage fJavaOutlinePage;

        public ToggleLinkingAction(VjoOutlinePage outlinePage) {
            boolean isLinkingEnabled = DLTKUIPlugin.getDefault().getPreferenceStore().getBoolean("syncOutlineOnCursorMove");
            this.setChecked(isLinkingEnabled);
            this.fJavaOutlinePage = outlinePage;
        }

        public void run() {
            DLTKUIPlugin.getDefault().getPreferenceStore().setValue("syncOutlineOnCursorMove", this.isChecked());
            if (this.isChecked() && VjoOutlinePage.this.fEditor != null) {
                VjoOutlinePage.this.fEditor.synchronizeOutlinePage(VjoOutlinePage.this.fEditor.computeHighlightRangeSourceReference(), false);
            }
        }
    }
}

