/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.rhino.dbgp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.client.WindowFactory;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugger;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.jsrunner.JsRunner;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;
import org.eclipse.vjet.vjo.VjBootstrapJsr;
import org.eclipse.vjet.vjo.loader.VjoConsole;
import org.eclipse.vjet.vjo.loader.VjoLoader;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.EcmaError;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.debug.Debugger;

public class DefaultRhinoRunner {
    private static final String DEBUG_MODE = "debug";
    private static final String RUN_MODE = "run";

    private void enableVjo(Context cx, Scriptable scope) {
        URL sourceUrl = null;
        try {
            sourceUrl = JavaSourceLocator.getInstance().getSourceUrl(VjBootstrapJsr.getSourceUri(), ".js");
            if (sourceUrl == null) {
                sourceUrl = VjBootstrapJsr.getJsAsUrl();
            }
            cx.evaluateReader(scope, (Reader)new InputStreamReader(sourceUrl.openStream()), sourceUrl.toExternalForm(), 0, null);
            VjoLoader.enable((Context)cx, (Scriptable)scope);
            VjoConsole.enable((Context)cx, (Scriptable)scope);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static JsRunner.ProgramInfo initDebuggingObjects(String[] args, DebuggingObjects dObj) {
        JsRunner.ProgramInfo pInfo = null;
        try {
            pInfo = JsRunner.getProgramInfo((String[])args);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (pInfo.getBrowserType() != null) {
            dObj._scope = (AWindow)WindowFactory.createWindow((BrowserType)pInfo.getBrowserType());
            dObj._cntx = ((AWindow)dObj._scope).getContext();
        } else {
            dObj._cntx = Context.enter();
            dObj._scope = dObj._cntx.initStandardObjects();
        }
        return pInfo;
    }

    public void run(String[] args) {
        DebuggingObjects dObjs = new DebuggingObjects();
        if (args[0].equalsIgnoreCase(DEBUG_MODE)) {
            String host = args[1];
            String port = args[2];
            String debuggingId = args[3];
            String[] pArgs = new String[args.length - 4];
            System.arraycopy(args, 4, pArgs, 0, pArgs.length);
            JsRunner.ProgramInfo pInfo = DefaultRhinoRunner.initDebuggingObjects(pArgs, dObjs);
            try {
                Socket socket = new Socket(host, Integer.parseInt(port));
                DBGPDebugger debugger = new DBGPDebugger(socket, pInfo.getFileName().toString(), debuggingId, dObjs._cntx);
                debugger.start();
                dObjs._cntx.setDebugger((Debugger)debugger, null);
                try {
                    dObjs._cntx.setGeneratingDebug(true);
                    dObjs._cntx.setOptimizationLevel(-1);
                    this.evaluate(dObjs, pInfo.getFileName(), this.makeRunLine(pInfo));
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                debugger.notifyEnd();
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
            catch (UnknownHostException uhe) {
                uhe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else if (args[0].equalsIgnoreCase(RUN_MODE)) {
            String[] pArgs = new String[args.length - 1];
            System.arraycopy(args, 1, pArgs, 0, pArgs.length);
            JsRunner.ProgramInfo pInfo = DefaultRhinoRunner.initDebuggingObjects(pArgs, dObjs);
            try {
                this.evaluate(dObjs, pInfo.getFileName(), this.makeRunLine(pInfo));
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private String makeRunLine(JsRunner.ProgramInfo pInfo) {
        String main = String.valueOf(pInfo.getJsClassName()) + ".main";
        String[] args = pInfo.getJsArgs();
        StringBuilder mainExec = new StringBuilder();
        mainExec.append("if(").append(main).append(") {\n").append(main).append("(");
        int i = 0;
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (i > 0) {
                    mainExec.append(",");
                }
                mainExec.append(JsonObject.quote((String)arg));
                ++i;
                ++n2;
            }
        }
        mainExec.append(");\n}");
        return mainExec.toString();
    }

    private void evaluate(DebuggingObjects dObjs, URL scriptUri, String main) throws IOException {
        this.enableVjo(dObjs._cntx, dObjs._scope);
        try {
            try {
                dObjs._cntx.evaluateReader(dObjs._scope, (Reader)new InputStreamReader(scriptUri.openStream()), scriptUri.toExternalForm(), 1, null);
                if (main != null) {
                    dObjs._cntx.evaluateString(dObjs._scope, main, "", 1, null);
                }
            }
            catch (EcmaError ee) {
                ee.printStackTrace();
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    private static class DebuggingObjects {
        Context _cntx;
        Scriptable _scope;

        private DebuggingObjects() {
        }
    }
}

