/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.viewsupport;

import java.util.ArrayList;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.ui.ScriptElementImageProvider;
import org.eclipse.dltk.mod.ui.ScriptElementLabels;
import org.eclipse.dltk.mod.ui.viewsupport.StorageLabelProvider;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ScriptUILabelProvider
implements ILabelProvider,
IColorProvider {
    protected ListenerList fListeners = new ListenerList(1);
    protected ScriptElementImageProvider fImageLabelProvider = new ScriptElementImageProvider();
    protected StorageLabelProvider fStorageLabelProvider = new StorageLabelProvider();
    private int fImageFlags;
    private long fTextFlags;
    private ArrayList fLabelDecorators;

    public ScriptUILabelProvider() {
        this(ScriptElementLabels.ALL_DEFAULT, 1);
        this.fLabelDecorators = null;
    }

    public ScriptUILabelProvider(long textFlags, int imageFlags) {
        this.fImageFlags = imageFlags;
        this.fTextFlags = textFlags;
        this.fLabelDecorators = null;
    }

    public final void setTextFlags(long textFlags) {
        this.fTextFlags = textFlags;
    }

    public final void setImageFlags(int imageFlags) {
        this.fImageFlags = imageFlags;
    }

    public final int getImageFlags() {
        return this.fImageFlags;
    }

    public final long getTextFlags() {
        return this.fTextFlags;
    }

    protected int evaluateImageFlags(Object element) {
        return this.getImageFlags();
    }

    protected long evaluateTextFlags(Object element) {
        return this.getTextFlags();
    }

    public Image getImage(Object element) {
        Image result = this.fImageLabelProvider.getImageLabel(element, this.evaluateImageFlags(element));
        if (result == null && (element instanceof IStorage || element instanceof ISourceModule)) {
            result = this.fStorageLabelProvider.getImage(element);
        }
        return this.decorateImage(result, element);
    }

    public String getText(Object element) {
        String result = ScriptElementLabels.getDefault().getTextLabel(element, this.evaluateTextFlags(element));
        if (result.length() == 0 && element instanceof IStorage) {
            result = this.fStorageLabelProvider.getText(element);
        }
        return this.decorateText(result, element);
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fLabelDecorators != null) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = (ILabelDecorator)this.fLabelDecorators.get(i);
                decorator.addListener(listener);
                ++i;
            }
        }
        this.fListeners.add((Object)listener);
    }

    public void dispose() {
        if (this.fLabelDecorators != null) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = (ILabelDecorator)this.fLabelDecorators.get(i);
                decorator.dispose();
                ++i;
            }
            this.fLabelDecorators = null;
        }
        this.fStorageLabelProvider.dispose();
        this.fImageLabelProvider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fLabelDecorators != null) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = (ILabelDecorator)this.fLabelDecorators.get(i);
                decorator.removeListener(listener);
                ++i;
            }
        }
        this.fListeners.remove((Object)listener);
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ILabelProviderListener l = (ILabelProviderListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.labelProviderChanged(event);
                }
            });
            ++i;
        }
    }

    public void addLabelDecorator(ILabelDecorator decorator) {
        if (this.fLabelDecorators == null) {
            this.fLabelDecorators = new ArrayList(2);
        }
        this.fLabelDecorators.add(decorator);
    }

    protected Image decorateImage(Image image, Object element) {
        if (this.fLabelDecorators != null && image != null) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = (ILabelDecorator)this.fLabelDecorators.get(i);
                image = decorator.decorateImage(image, element);
                ++i;
            }
        }
        return image;
    }

    protected String decorateText(String text, Object element) {
        if (this.fLabelDecorators != null && text.length() > 0) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = (ILabelDecorator)this.fLabelDecorators.get(i);
                text = decorator.decorateText(text, element);
                ++i;
            }
        }
        return text;
    }
}

