/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.templates;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.templates.TemplateMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public abstract class ScriptTemplateAccess {
    private ContributionContextTypeRegistry fRegistry;
    private TemplateStore fStore;

    public TemplateStore getTemplateStore() {
        if (this.fStore == null) {
            this.fStore = new ContributionTemplateStore(this.getContextTypeRegistry(), this.getPreferenceStore(), this.getCustomTemplatesKey());
            this.loadTemplates();
        }
        return this.fStore;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = new ContributionContextTypeRegistry();
            this.fRegistry.addContextType(this.getContextTypeId());
        }
        return this.fRegistry;
    }

    protected abstract String getContextTypeId();

    protected abstract String getCustomTemplatesKey();

    protected abstract IPreferenceStore getPreferenceStore();

    private void loadTemplates() {
        try {
            this.fStore.load();
        }
        catch (IOException e) {
            DLTKUIPlugin.logErrorMessage(MessageFormat.format(TemplateMessages.ScriptTemplateAccess_unableToLoadTemplateStore, e));
        }
    }
}

