/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.internal.corext.refactoring.rename.RenameScriptFolderProcessor;
import org.eclipse.dltk.mod.internal.corext.refactoring.rename.RenameScriptProjectProcessor;
import org.eclipse.dltk.mod.internal.corext.refactoring.rename.RenameSourceFolderProcessor;
import org.eclipse.dltk.mod.internal.corext.refactoring.rename.RenameSourceModuleProcessor;
import org.eclipse.dltk.mod.internal.corext.refactoring.rename.ScriptRenameProcessor;
import org.eclipse.dltk.mod.internal.corext.refactoring.rename.ScriptRenameRefactoring;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.dltk.mod.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.mod.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.dltk.mod.internal.ui.refactoring.reorg.RenameUserInterfaceManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.swt.widgets.Shell;

public class RenameSupport {
    private RenameRefactoring fRefactoring;
    private RefactoringStatus fPreCheckStatus;
    public static final int NONE = 0;
    public static final int UPDATE_REFERENCES = 1;
    public static final int UPDATE_TEXTUAL_MATCHES = 64;

    public static RenameSupport create(IScriptProject project, String newName, int flags) throws CoreException {
        RenameScriptProjectProcessor processor = new RenameScriptProjectProcessor(project);
        return new RenameSupport(processor, newName, flags);
    }

    private RenameSupport(ScriptRenameProcessor processor, String newName, int flags) throws CoreException {
        this.fRefactoring = new ScriptRenameRefactoring(processor);
        RenameSupport.initialize(this.fRefactoring, newName, flags);
    }

    public static RenameSupport create(IProjectFragment root, String newName) throws CoreException {
        RenameSourceFolderProcessor processor = new RenameSourceFolderProcessor(root);
        return new RenameSupport(processor, newName, 0);
    }

    public static RenameSupport create(IScriptFolder fragment, String newName, int flags) throws CoreException {
        RenameScriptFolderProcessor processor = new RenameScriptFolderProcessor(fragment);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(ISourceModule unit, String newName, int flags) throws CoreException {
        RenameSourceModuleProcessor processor = new RenameSourceModuleProcessor(unit);
        return new RenameSupport(processor, newName, flags);
    }

    public IStatus preCheck() throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            return this.fPreCheckStatus.getEntryMatchingSeverity(4).toStatus();
        }
        return new Status(0, "org.eclipse.dltk.mod.ui", 0, "", null);
    }

    private void ensureChecked() throws CoreException {
        if (this.fPreCheckStatus == null) {
            this.fPreCheckStatus = !this.fRefactoring.isApplicable() ? RefactoringStatus.createFatalErrorStatus((String)DLTKUIMessages.RenameSupport_not_available) : new RefactoringStatus();
        }
    }

    public void openDialog(Shell parent) throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            this.showInformation(parent, this.fPreCheckStatus);
            return;
        }
        UserInterfaceStarter starter = RenameUserInterfaceManager.getDefault().getStarter((Refactoring)this.fRefactoring);
        starter.activate((Refactoring)this.fRefactoring, parent, this.getScriptRenameProcessor().needsSavedEditors());
    }

    private void showInformation(Shell parent, RefactoringStatus status) {
        String message = status.getMessageMatchingSeverity(4);
        MessageDialog.openInformation((Shell)parent, (String)DLTKUIMessages.RenameSupport_dialog_title, (String)message);
    }

    private ScriptRenameProcessor getScriptRenameProcessor() {
        return (ScriptRenameProcessor)this.fRefactoring.getProcessor();
    }

    private static void initialize(RenameRefactoring refactoring, String newName, int flags) {
        ITextUpdating text;
        if (refactoring.getProcessor() == null) {
            return;
        }
        RenameSupport.setNewName((INameUpdating)refactoring.getAdapter(INameUpdating.class), newName);
        IReferenceUpdating reference = (IReferenceUpdating)refactoring.getAdapter(IReferenceUpdating.class);
        if (reference != null) {
            reference.setUpdateReferences(RenameSupport.updateReferences(flags));
        }
        if ((text = (ITextUpdating)refactoring.getAdapter(ITextUpdating.class)) != null) {
            text.setUpdateTextualMatches(RenameSupport.updateTextualMatches(flags));
        }
    }

    private static void setNewName(INameUpdating refactoring, String newName) {
        if (newName != null) {
            refactoring.setNewElementName(newName);
        }
    }

    private static boolean updateReferences(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean updateTextualMatches(int flags) {
        int TEXT_UPDATES = 64;
        return (flags & TEXT_UPDATES) != 0;
    }
}

