/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.actions;

import java.util.ArrayList;
import org.eclipse.dltk.mod.ui.viewsupport.AbstractModelElementFilter;
import org.eclipse.dltk.mod.ui.viewsupport.MemberFilter;
import org.eclipse.dltk.mod.ui.viewsupport.MemberFilterAction;
import org.eclipse.dltk.mod.ui.viewsupport.ModelElementFlagsFilter;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionGroup;

public class MemberFilterActionGroup
extends ActionGroup {
    IPreferenceStore fStore;
    private MemberFilterAction[] fFilterActions;
    private MemberFilter fFilter;
    public static final int FILTER_NONPUBLIC = 1;
    public static final int FILTER_STATIC = 2;
    public static final int FILTER_FIELDS = 4;
    public static final int FILTER_LOCALTYPES = 8;
    public static final int ALL_FILTERS = 15;
    private StructuredViewer fViewer;
    private boolean fInViewMenu;
    String title;
    String helpContext;

    public MemberFilterActionGroup(StructuredViewer viewer, IPreferenceStore store) {
        this(viewer, store, false);
    }

    public MemberFilterActionGroup(StructuredViewer viewer, IPreferenceStore store, boolean inViewMenu) {
        this.fViewer = viewer;
        this.fStore = store;
        this.fInViewMenu = inViewMenu;
        ArrayList<MemberFilterAction> actions = new ArrayList<MemberFilterAction>(4);
        this.fFilter = new MemberFilter();
        int filterProperty = 4;
        if (this.isSet(filterProperty, 15)) {
            this.title = ActionMessages.MemberFilterActionGroup_hide_fields_label;
            this.helpContext = "org.eclipse.jdt.ui.filter_fields_action";
            MemberFilterAction hideFields = new MemberFilterAction(this, this.title, new ModelElementFlagsFilter(filterProperty), this.helpContext, false);
            hideFields.setDescription(ActionMessages.MemberFilterActionGroup_hide_fields_description);
            hideFields.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_fields_tooltip);
            JavaPluginImages.setLocalImageDescriptors((IAction)hideFields, (String)"fields_co.gif");
            actions.add(hideFields);
        }
        if (this.isSet(filterProperty = 2, 15)) {
            this.title = ActionMessages.MemberFilterActionGroup_hide_static_label;
            this.helpContext = "org.eclipse.jdt.ui.filter_static_action";
            MemberFilterAction hideStatic = new MemberFilterAction(this, this.title, new ModelElementFlagsFilter(filterProperty), this.helpContext, false);
            hideStatic.setDescription(ActionMessages.MemberFilterActionGroup_hide_static_description);
            hideStatic.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_static_tooltip);
            JavaPluginImages.setLocalImageDescriptors((IAction)hideStatic, (String)"static_co.gif");
            actions.add(hideStatic);
        }
        if (this.isSet(filterProperty = 1, 15)) {
            this.title = ActionMessages.MemberFilterActionGroup_hide_nonpublic_label;
            this.helpContext = "org.eclipse.jdt.ui.filter_public_action";
            MemberFilterAction hideNonPublic = new MemberFilterAction(this, this.title, new ModelElementFlagsFilter(filterProperty), this.helpContext, false);
            hideNonPublic.setDescription(ActionMessages.MemberFilterActionGroup_hide_nonpublic_description);
            hideNonPublic.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_nonpublic_tooltip);
            JavaPluginImages.setLocalImageDescriptors((IAction)hideNonPublic, (String)"public_co.gif");
            actions.add(hideNonPublic);
        }
        this.fFilterActions = actions.toArray(new MemberFilterAction[actions.size()]);
    }

    private boolean isSet(int flag, int set) {
        return (flag & set) != 0;
    }

    public void setActions(MemberFilterAction[] actions) {
        this.fFilterActions = new MemberFilterAction[actions.length];
        int i = 0;
        while (i < actions.length) {
            MemberFilterAction action = actions[i];
            AbstractModelElementFilter filter = action.getFilter();
            boolean filterEnabled = false;
            if (this.fStore != null) {
                filterEnabled = this.fStore.getBoolean(this.getPreferenceKey(action.getFilter().getFilteringType()));
            }
            if (filterEnabled) {
                this.fViewer.addFilter((ViewerFilter)filter);
            } else {
                this.fViewer.removeFilter((ViewerFilter)filter);
            }
            action.setChecked(filterEnabled);
            this.fFilterActions[i] = action;
            ++i;
        }
    }

    private String getPreferenceKey(String filterProperty) {
        return "MemberFilterActionGroup." + filterProperty;
    }

    public void processMemberFilterAction(MemberFilterAction action) {
        boolean set = action.isChecked();
        AbstractModelElementFilter filter = action.getFilter();
        if (this.fStore != null) {
            this.fStore.setValue(this.getPreferenceKey(filter.getFilteringType()), set);
        }
        if (set) {
            this.fViewer.addFilter((ViewerFilter)filter);
        } else {
            this.fViewer.removeFilter((ViewerFilter)filter);
        }
        this.fViewer.getControl().setRedraw(false);
        BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                MemberFilterActionGroup.this.fViewer.refresh();
            }
        });
        this.fViewer.getControl().setRedraw(true);
    }

    public void fillActionBars(IActionBars actionBars) {
        this.contributeToToolBar(actionBars.getToolBarManager());
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        if (this.fInViewMenu || this.fFilterActions == null) {
            return;
        }
        int i = 0;
        while (i < this.fFilterActions.length) {
            tbm.add((IAction)this.fFilterActions[i]);
            ++i;
        }
    }

    public void contributeToViewMenu(IMenuManager menu) {
        if (!this.fInViewMenu) {
            return;
        }
        if (menu.find("filters") != null) {
            int i = 0;
            while (i < this.fFilterActions.length) {
                menu.prependToGroup("filters", (IAction)this.fFilterActions[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.fFilterActions.length) {
                menu.add((IAction)this.fFilterActions[i]);
                ++i;
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }
}

