/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.wizards.buildpath;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathAttribute;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.internal.ui.wizards.BuildpathAttributeConfiguration;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.BPListElement;

public class BPListElementAttribute {
    private BPListElement fParent;
    private String fKey;
    private Object fValue;
    private IStatus fStatus;
    private final boolean fBuiltIn;
    private BuildpathAttributeConfiguration.BuildpathAttributeAccess fCachedAccess;

    public BPListElementAttribute(BPListElement parent, String key, Object value, boolean builtIn) {
        this.fKey = key;
        this.fValue = value;
        this.fParent = parent;
        this.fBuiltIn = builtIn;
        if (!builtIn) {
            Assert.isTrue((value instanceof String || value == null ? 1 : 0) != 0);
        }
    }

    public IBuildpathAttribute newBuildpathAttribute() {
        Assert.isTrue((!this.fBuiltIn ? 1 : 0) != 0);
        if (this.fValue != null) {
            return DLTKCore.newBuildpathAttribute((String)this.fKey, (String)((String)this.fValue));
        }
        return null;
    }

    public BPListElement getParent() {
        return this.fParent;
    }

    public boolean isBuiltIn() {
        return this.fBuiltIn;
    }

    public boolean isInNonModifiableContainer() {
        return this.fParent.isInNonModifiableContainer();
    }

    public String getKey() {
        return this.fKey;
    }

    public Object getValue() {
        return this.fValue;
    }

    public void setValue(Object value) {
        this.fValue = value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BPListElementAttribute)) {
            return false;
        }
        BPListElementAttribute attrib = (BPListElementAttribute)obj;
        return attrib.fKey == this.fKey && attrib.getParent().getPath().equals((Object)this.fParent.getPath());
    }

    public IBuildpathAttribute getBuildpathAttribute() {
        Assert.isTrue((!this.fBuiltIn ? 1 : 0) != 0);
        return DLTKCore.newBuildpathAttribute((String)this.fKey, (String)((String)this.fValue));
    }

    public BuildpathAttributeConfiguration.BuildpathAttributeAccess getBuildpathAttributeAccess() {
        if (this.fCachedAccess == null) {
            this.fCachedAccess = new BuildpathAttributeConfiguration.BuildpathAttributeAccess(){

                @Override
                public IBuildpathAttribute getBuildpathAttribute() {
                    return BPListElementAttribute.this.getBuildpathAttribute();
                }

                @Override
                public IScriptProject getScriptProject() {
                    return BPListElementAttribute.this.getParent().getScriptProject();
                }

                @Override
                public IBuildpathEntry getParentBuildpathEntry() {
                    return BPListElementAttribute.this.getParent().getBuildpathEntry();
                }
            };
        }
        return this.fCachedAccess;
    }
}

