/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.typehierarchy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.ElementChangedEvent;
import org.eclipse.dltk.mod.core.IElementChangedListener;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelElementDelta;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IRegion;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ITypeHierarchy;
import org.eclipse.dltk.mod.core.ITypeHierarchyChangedListener;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.ScriptModelUtil;
import org.eclipse.dltk.mod.internal.ui.typehierarchy.ITypeHierarchyLifeCycleListener;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class TypeHierarchyLifeCycle
implements ITypeHierarchyChangedListener,
IElementChangedListener {
    private boolean fHierarchyRefreshNeeded;
    private ITypeHierarchy fHierarchy = null;
    private IModelElement fInputElement = null;
    private boolean fIsSuperTypesOnly;
    private List fChangeListeners;

    public TypeHierarchyLifeCycle() {
        this(false);
    }

    public TypeHierarchyLifeCycle(boolean isSuperTypesOnly) {
        this.fIsSuperTypesOnly = isSuperTypesOnly;
        this.fChangeListeners = new ArrayList(2);
    }

    public ITypeHierarchy getHierarchy() {
        return this.fHierarchy;
    }

    public IModelElement getInputElement() {
        return this.fInputElement;
    }

    public void freeHierarchy() {
        if (this.fHierarchy != null) {
            this.fHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            DLTKCore.removeElementChangedListener((IElementChangedListener)this);
            this.fHierarchy = null;
            this.fInputElement = null;
        }
    }

    public void removeChangedListener(ITypeHierarchyLifeCycleListener listener) {
        this.fChangeListeners.remove(listener);
    }

    public void addChangedListener(ITypeHierarchyLifeCycleListener listener) {
        if (!this.fChangeListeners.contains(listener)) {
            this.fChangeListeners.add(listener);
        }
    }

    private void fireChange(IType[] changedTypes) {
        int i = this.fChangeListeners.size() - 1;
        while (i >= 0) {
            ITypeHierarchyLifeCycleListener curr = (ITypeHierarchyLifeCycleListener)this.fChangeListeners.get(i);
            curr.typeHierarchyChanged(this, changedTypes);
            --i;
        }
    }

    public void ensureRefreshedTypeHierarchy(final IModelElement element, IRunnableContext context) throws InvocationTargetException, InterruptedException {
        boolean hierachyCreationNeeded;
        if (element == null || !element.exists()) {
            this.freeHierarchy();
            return;
        }
        boolean bl = hierachyCreationNeeded = this.fHierarchy == null || !element.equals(this.fInputElement);
        if (hierachyCreationNeeded || this.fHierarchyRefreshNeeded) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                    try {
                        TypeHierarchyLifeCycle.this.doHierarchyRefresh(element, pm);
                    }
                    catch (ModelException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
            };
            this.fHierarchyRefreshNeeded = true;
            context.run(true, true, op);
            this.fHierarchyRefreshNeeded = false;
        }
    }

    private ITypeHierarchy createTypeHierarchy(IModelElement element, IProgressMonitor pm) throws ModelException {
        IProjectFragment[] roots;
        if (element.getElementType() == 7) {
            IType type = (IType)element;
            if (this.fIsSuperTypesOnly) {
                return type.newSupertypeHierarchy(pm);
            }
            return type.newTypeHierarchy(pm);
        }
        IRegion region = DLTKCore.newRegion();
        if (element.getElementType() == 2) {
            roots = ((IScriptProject)element).getProjectFragments();
            int i = 0;
            while (i < roots.length) {
                if (!roots[i].isExternal()) {
                    region.add((IModelElement)roots[i]);
                }
                ++i;
            }
        } else if (element.getElementType() == 3) {
            roots = element.getScriptProject().getProjectFragments();
            String name = element.getElementName();
            int i = 0;
            while (i < roots.length) {
                IScriptFolder pack = roots[i].getScriptFolder(name);
                if (pack.exists()) {
                    region.add((IModelElement)pack);
                }
                ++i;
            }
        } else {
            region.add(element);
        }
        IScriptProject jproject = element.getScriptProject();
        return jproject.newTypeHierarchy(region, pm);
    }

    public synchronized void doHierarchyRefresh(IModelElement element, IProgressMonitor pm) throws ModelException {
        boolean hierachyCreationNeeded;
        boolean bl = hierachyCreationNeeded = this.fHierarchy == null || !element.equals(this.fInputElement);
        if (this.fHierarchy != null) {
            this.fHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            DLTKCore.removeElementChangedListener((IElementChangedListener)this);
        }
        if (hierachyCreationNeeded) {
            this.fHierarchy = this.createTypeHierarchy(element, pm);
            if (pm != null && pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fInputElement = element;
        } else {
            this.fHierarchy.refresh(pm);
        }
        this.fHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        DLTKCore.addElementChangedListener((IElementChangedListener)this);
        this.fHierarchyRefreshNeeded = false;
    }

    public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
        this.fHierarchyRefreshNeeded = true;
        this.fireChange(null);
    }

    public void elementChanged(ElementChangedEvent event) {
        if (this.fChangeListeners.isEmpty()) {
            return;
        }
        if (this.fHierarchyRefreshNeeded) {
            return;
        }
        ArrayList changedTypes = new ArrayList();
        this.processDelta(event.getDelta(), changedTypes);
        if (changedTypes.size() > 0) {
            this.fireChange(changedTypes.toArray(new IType[changedTypes.size()]));
        }
    }

    private void processDelta(IModelElementDelta delta, ArrayList changedTypes) {
        IModelElement element = delta.getElement();
        switch (element.getElementType()) {
            case 7: {
                this.processTypeDelta((IType)element, changedTypes);
                this.processChildrenDelta(delta, changedTypes);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.processChildrenDelta(delta, changedTypes);
                break;
            }
            case 5: {
                ISourceModule cu = (ISourceModule)element;
                if (!ScriptModelUtil.isPrimary((ISourceModule)cu)) {
                    return;
                }
                if (delta.getKind() == 4 && this.isPossibleStructuralChange(delta.getFlags())) {
                    try {
                        if (!cu.exists()) break;
                        IType[] types = cu.getAllTypes();
                        int i = 0;
                        while (i < types.length) {
                            this.processTypeDelta(types[i], changedTypes);
                            ++i;
                        }
                    }
                    catch (ModelException e) {
                        DLTKUIPlugin.log(e);
                    }
                    break;
                }
                this.processChildrenDelta(delta, changedTypes);
            }
        }
    }

    private boolean isPossibleStructuralChange(int flags) {
        return (flags & 0x4001) == 1;
    }

    private void processTypeDelta(IType type, ArrayList changedTypes) {
        if (this.getHierarchy().contains(type)) {
            changedTypes.add(type);
        }
    }

    private void processChildrenDelta(IModelElementDelta delta, ArrayList changedTypes) {
        IModelElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processDelta(children[i], changedTypes);
            ++i;
        }
    }
}

