/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;

public class ScriptSourcePreviewerUpdater {
    public ScriptSourcePreviewerUpdater(final SourceViewer viewer, final ScriptSourceViewerConfiguration configuration, final IPreferenceStore preferenceStore) {
        Assert.isNotNull((Object)viewer);
        Assert.isNotNull((Object)((Object)configuration));
        Assert.isNotNull((Object)preferenceStore);
        final IPropertyChangeListener fontChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String fontKey = configuration.getFontPropertyPreferenceKey();
                if (fontKey.equals(event.getProperty())) {
                    Font font = JFaceResources.getFont((String)fontKey);
                    viewer.getTextWidget().setFont(font);
                }
            }
        };
        final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (configuration.affectsTextPresentation(event)) {
                    configuration.handlePropertyChangeEvent(event);
                    viewer.invalidateTextPresentation();
                }
            }
        };
        viewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                preferenceStore.removePropertyChangeListener(propertyChangeListener);
                JFaceResources.getFontRegistry().removeListener(fontChangeListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(fontChangeListener);
        preferenceStore.addPropertyChangeListener(propertyChangeListener);
    }
}

