/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.editor;

import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.ui.actions.SelectionConverter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;

public class ModelTextSelection
extends TextSelection {
    private IModelElement fElement;
    private IModelElement[] fResolvedElements;
    private boolean fEnclosingElementRequested;
    private IModelElement fEnclosingElement;

    public ModelTextSelection(IModelElement element, IDocument document, int offset, int length) {
        super(document, offset, length);
        this.fElement = element;
    }

    public IModelElement[] resolveElementAtOffset() throws ModelException {
        if (this.fResolvedElements != null) {
            return this.fResolvedElements;
        }
        this.fResolvedElements = SelectionConverter.codeResolve(this.fElement, (ITextSelection)this);
        return this.fResolvedElements;
    }

    public IModelElement resolveEnclosingElement() throws ModelException {
        if (this.fEnclosingElementRequested) {
            return this.fEnclosingElement;
        }
        this.fEnclosingElementRequested = true;
        this.fEnclosingElement = SelectionConverter.resolveEnclosingElement(this.fElement, (ITextSelection)this);
        return this.fEnclosingElement;
    }
}

