/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.browsing;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;

public class LogicalPackage
extends PlatformObject {
    private Set fPackages = new HashSet();
    private String fName;
    private IScriptProject fScriptProject;

    public LogicalPackage(IScriptFolder fragment) {
        this.fScriptProject = fragment.getScriptProject();
        this.add(fragment);
        this.fName = fragment.getElementName();
    }

    public IScriptProject getScriptProject() {
        return this.fScriptProject;
    }

    public IScriptFolder[] getFragments() {
        return this.fPackages.toArray(new IScriptFolder[this.fPackages.size()]);
    }

    public void add(IScriptFolder fragment) {
        Assert.isTrue((fragment != null && this.fScriptProject.equals(fragment.getScriptProject()) ? 1 : 0) != 0);
        this.fPackages.add(fragment);
    }

    public void remove(IScriptFolder fragment) {
        this.fPackages.remove(fragment);
    }

    public boolean contains(IScriptFolder fragment) {
        return this.fPackages.contains(fragment);
    }

    public String getElementName() {
        return this.fName;
    }

    public int size() {
        return this.fPackages.size();
    }

    public boolean belongs(IScriptFolder fragment) {
        if (fragment == null) {
            return false;
        }
        if (this.fScriptProject.equals(fragment.getScriptProject())) {
            return this.fName.equals(fragment.getElementName());
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LogicalPackage)) {
            return false;
        }
        LogicalPackage lp = (LogicalPackage)((Object)o);
        if (!this.fScriptProject.equals(lp.getScriptProject())) {
            return false;
        }
        IScriptFolder[] fragments = lp.getFragments();
        if (fragments.length != this.getFragments().length) {
            return false;
        }
        int i = 0;
        while (i < fragments.length) {
            IScriptFolder fragment = fragments[i];
            if (!this.fPackages.contains(fragment)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        IScriptFolder[] fragments = this.getFragments();
        return this.fScriptProject.hashCode() + this.getHash(fragments, fragments.length - 1);
    }

    private int getHash(IScriptFolder[] fragments, int index) {
        if (index <= 0) {
            return fragments[0].hashCode() * 17;
        }
        return fragments[index].hashCode() * 17 + this.getHash(fragments, index - 1);
    }
}

