/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui;

import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;

public class JarEntryFile
extends PlatformObject
implements IStorage {
    private ZipFile fZipFile;
    private String fEntryName;

    public JarEntryFile(ZipFile zipFile, String entryName) {
        this.fZipFile = zipFile;
        this.fEntryName = entryName;
    }

    public InputStream getContents() throws CoreException {
        try {
            if (this.fEntryName.startsWith("/")) {
                this.fEntryName = this.fEntryName.substring(1);
            }
            ZipEntry zipEntry = this.fZipFile.getEntry(this.fEntryName);
            return this.fZipFile.getInputStream(zipEntry);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.mod.ui", 4, e.getMessage(), (Throwable)e));
        }
    }

    public IPath getFullPath() {
        return new Path(this.fEntryName);
    }

    public String getName() {
        return this.getFullPath().lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(ZipFile.class)) {
            return this.fZipFile;
        }
        if (adapter.equals(File.class)) {
            return new File(this.fZipFile.getName());
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return "JarEntryFile[" + this.fZipFile.getName() + "::" + this.fEntryName + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JarEntryFile)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

