/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.dltk.mod.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.dltk.mod.internal.corext.refactoring.structure.ScriptMoveRefactoring;
import org.eclipse.dltk.mod.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.dltk.mod.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.mod.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.dltk.mod.internal.ui.refactoring.reorg.CreateTargetQueries;
import org.eclipse.dltk.mod.internal.ui.refactoring.reorg.ReorgMoveWizard;
import org.eclipse.dltk.mod.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.dltk.mod.internal.ui.refactoring.reorg.ScriptMoveProcessor;
import org.eclipse.dltk.mod.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.swt.widgets.Shell;

public class ReorgMoveStarter {
    private final ScriptMoveProcessor fMoveProcessor;

    private ReorgMoveStarter(ScriptMoveProcessor moveProcessor) {
        Assert.isNotNull((Object)moveProcessor);
        this.fMoveProcessor = moveProcessor;
    }

    public static ReorgMoveStarter create(IModelElement[] modelElements, IResource[] resources, IModelElement destination) throws ModelException {
        Assert.isNotNull((Object)modelElements);
        Assert.isNotNull((Object)resources);
        Assert.isNotNull((Object)destination);
        IReorgPolicy.IMovePolicy policy = ReorgPolicyFactory.createMovePolicy(resources, modelElements);
        if (!policy.canEnable()) {
            return null;
        }
        ScriptMoveProcessor processor = new ScriptMoveProcessor(policy);
        if (!processor.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgMoveStarter(processor);
    }

    public static ReorgMoveStarter create(IModelElement[] modelElements, IResource[] resources, IResource destination) throws ModelException {
        Assert.isNotNull((Object)modelElements);
        Assert.isNotNull((Object)resources);
        Assert.isNotNull((Object)destination);
        IReorgPolicy.IMovePolicy policy = ReorgPolicyFactory.createMovePolicy(resources, modelElements);
        if (!policy.canEnable()) {
            return null;
        }
        ScriptMoveProcessor processor = new ScriptMoveProcessor(policy);
        if (!processor.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgMoveStarter(processor);
    }

    public void run(Shell parent) throws InterruptedException, InvocationTargetException {
        try {
            ScriptMoveRefactoring ref = new ScriptMoveRefactoring(this.fMoveProcessor);
            if (this.fMoveProcessor.hasAllInputSet()) {
                ProgressMonitorDialog context = new ProgressMonitorDialog(parent);
                this.fMoveProcessor.setCreateTargetQueries(new CreateTargetQueries(parent));
                this.fMoveProcessor.setReorgQueries(new ReorgQueries(parent));
                new RefactoringExecutionHelper((Refactoring)ref, RefactoringCore.getConditionCheckingFailedSeverity(), true, parent, (IRunnableContext)context).perform(false);
            } else {
                ReorgMoveWizard wizard = new ReorgMoveWizard(ref);
                this.fMoveProcessor.setCreateTargetQueries(new CreateTargetQueries((Wizard)wizard));
                this.fMoveProcessor.setReorgQueries(new ReorgQueries((Wizard)wizard));
                new RefactoringStarter().activate((Refactoring)ref, wizard, parent, RefactoringMessages.OpenRefactoringWizardAction_refactoring, true);
            }
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

