/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.refactoring.nls.changes;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.corext.refactoring.nls.NLSUtil;
import org.eclipse.dltk.mod.internal.corext.refactoring.nls.changes.CreateFileChange;

public class CreateTextFileChange
extends CreateFileChange {
    private final String fTextType;

    public CreateTextFileChange(IPath path, String source, String encoding, String textType) {
        super(path, source, encoding);
        this.fTextType = textType;
    }

    public String getTextType() {
        return this.fTextType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCurrentContent() throws ModelException {
        String string;
        IFile file = this.getOldFile((IProgressMonitor)new NullProgressMonitor());
        if (!file.exists()) {
            return "";
        }
        InputStream stream = null;
        try {
            stream = file.getContents();
            String c = NLSUtil.readString(stream);
            string = c == null ? "" : c;
        }
        catch (CoreException e) {
            try {
                throw new ModelException((Throwable)e, 966);
            }
            catch (Throwable throwable) {
                try {
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            if (stream == null) return string;
            stream.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }

    public String getPreview() {
        return this.getSource();
    }
}

