/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.console.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.console.ui.internal.Messages;
import org.eclipse.dltk.mod.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;

public class HTTPConsoleHyperlink
implements IHyperlink {
    private TextConsole fConsole;

    public HTTPConsoleHyperlink(TextConsole console) {
        this.fConsole = console;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        String uri = this.getLinkURI();
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = browserSupport.createBrowser(null);
            browser.openURL(new URL(uri));
        }
        catch (PartInitException e) {
            Status status = new Status(4, "org.eclipse.dltk.mod.launching", MessageFormat.format(Messages.HTTPConsoleHyperlink_failedToInitializeBrowserFor, uri), (Throwable)e);
            DLTKLaunchingPlugin.getDefault().getLog().log((IStatus)status);
        }
        catch (MalformedURLException e) {
            Status status = new Status(4, "org.eclipse.dltk.mod.launching", MessageFormat.format(Messages.HTTPConsoleHyperlink_failedToOpenInvalidUri, uri), (Throwable)e);
            DLTKLaunchingPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    protected TextConsole getConsole() {
        return this.fConsole;
    }

    protected String getLinkURI() {
        try {
            IDocument document = this.getConsole().getDocument();
            IRegion region = this.getConsole().getRegion((IHyperlink)this);
            return document.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

