/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.docprocessing;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.vjet.dsf.common.context.BaseSubCtx;
import org.eclipse.vjet.dsf.common.context.ContextHelper;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.context.ISubCtx;
import org.eclipse.vjet.vsf.docprocessing.DefaultProductionPlan;
import org.eclipse.vjet.vsf.docprocessing.IDocModifier;
import org.eclipse.vjet.vsf.docprocessing.IProductionPlan;

public class ProductionCtx
extends BaseSubCtx {
    private IProductionPlan m_plan;
    private Queue<IDocModifier> m_docModifiers;

    public static ProductionCtx ctx() {
        ProductionCtx context = CtxAssociator.getCtx();
        if (context == null) {
            context = new ProductionCtx();
            ProductionCtx.setCtx(context);
        }
        return context;
    }

    public static void setCtx(ProductionCtx context) {
        CtxAssociator.setCtx(context);
    }

    private ProductionCtx() {
    }

    public Queue<IDocModifier> getDocModifiersQueue() {
        if (this.m_docModifiers == null) {
            this.m_docModifiers = new ConcurrentLinkedQueue<IDocModifier>();
        }
        return this.m_docModifiers;
    }

    public Iterable<IDocModifier> getDocModifiers() {
        return this.getDocModifiersQueue();
    }

    public void addDocModifier(IDocModifier modifier) {
        Queue<IDocModifier> queue = this.getDocModifiersQueue();
        if (!queue.contains(modifier)) {
            queue.add(modifier);
        }
    }

    public boolean hasDocModifiers() {
        if (this.m_docModifiers == null) {
            return false;
        }
        return !this.m_docModifiers.isEmpty();
    }

    public void reset() {
        this.m_plan = null;
        this.m_docModifiers = null;
    }

    public IProductionPlan getPlan() {
        if (this.m_plan == null) {
            this.m_plan = new DefaultProductionPlan();
        }
        return this.m_plan;
    }

    public void setPlan(IProductionPlan plan) {
        this.m_plan = plan;
    }

    private static class CtxAssociator
    extends ContextHelper {
        private static final String CTX_NAME = ProductionCtx.class.getSimpleName();

        private CtxAssociator() {
        }

        protected static ProductionCtx getCtx() {
            return (ProductionCtx)((Object)CtxAssociator.getSubCtx((DsfCtx)DsfCtx.ctx(), (String)CTX_NAME));
        }

        protected static void setCtx(ProductionCtx ctx) {
            CtxAssociator.setSubCtx((DsfCtx)DsfCtx.ctx(), (String)CTX_NAME, (ISubCtx)ctx);
        }
    }
}

