/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui.launchConf;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ScriptSelectionDialog
extends FilteredResourcesSelectionDialog {
    public static final String JS_EXTENSION_PATTERN = "*.js";

    public ScriptSelectionDialog(Shell shell, boolean multi, IContainer container) {
        super(shell, multi, container, 1);
        this.setInitialPattern(JS_EXTENSION_PATTERN);
        this.setListLabelProvider((ILabelProvider)new ScriptLabelProvider());
    }

    protected String getMessage() {
        return "Select JavaScript File";
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ScriptFilter();
    }

    class ScriptFilter
    extends FilteredResourcesSelectionDialog.ResourceFilter {
        ScriptFilter() {
            super((FilteredResourcesSelectionDialog)ScriptSelectionDialog.this);
        }

        public boolean matchItem(Object item) {
            return super.matchItem(item) && this.isJavaScriptContent((IFile)item);
        }

        boolean isJavaScriptContent(IFile file) {
            IContentType filetype = IDE.getContentType((IFile)file);
            if (filetype == null) {
                return false;
            }
            IContentType scripttype = Platform.getContentTypeManager().getContentType("org.eclipse.dltk.mod.vjoContentType");
            return filetype.equals(scripttype);
        }
    }

    private final class ScriptLabelProvider
    extends LabelProvider
    implements ILabelProviderListener {
        private ListenerList listeners = new ListenerList();
        WorkbenchLabelProvider provider = new WorkbenchLabelProvider();
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();

        private ScriptLabelProvider() {
        }

        public Image getImage(Object element) {
            if (!(element instanceof IResource)) {
                return super.getImage(element);
            }
            IResource res = (IResource)element;
            Image img = this.provider.getImage((Object)res);
            return this.decorator.decorateImage(img, (Object)res);
        }

        public String getText(Object element) {
            if (!(element instanceof IResource)) {
                return super.getText(element);
            }
            IResource res = (IResource)element;
            String str = String.valueOf(res.getName()) + " - " + res.getParent().getFullPath().makeRelative().toString();
            if (ScriptSelectionDialog.this.isDuplicateElement(element)) {
                str = String.valueOf(str) + " - " + res.getParent().getFullPath().makeRelative().toString();
            }
            return this.decorator.decorateText(str, (Object)res);
        }

        public void dispose() {
            this.provider.removeListener((ILabelProviderListener)this);
            this.provider.dispose();
            this.decorator.removeListener((ILabelProviderListener)this);
            this.decorator.dispose();
            super.dispose();
        }

        public void addListener(ILabelProviderListener listener) {
            this.listeners.add((Object)listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.listeners.remove((Object)listener);
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] l = this.listeners.getListeners();
            int i = 0;
            while (i < this.listeners.size()) {
                ((ILabelProviderListener)l[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }
}

