/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DDocumentType;
import org.eclipse.vjet.dsf.dom.DEntity;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DNotation;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;

public final class DomUtil {
    private DomUtil() {
    }

    public static void fillFrom(DNode node, Node orig) {
        node.setNodeValue(orig.getNodeValue());
        node.setPrefix(orig.getPrefix());
        orig.getPrefix();
        orig.getLocalName();
        NamedNodeMap map = orig.getAttributes();
        int len = map.getLength();
        int i = 0;
        while (i < len) {
            Attr attr = (Attr)map.item(i);
            DAttr newAttr = DomUtil.from(attr);
            node.getAttributes().setNamedItem(newAttr);
            ++i;
        }
    }

    public static DAttr from(Attr orig) {
        DAttr answer = new DAttr(orig.getName(), orig.getValue());
        DomUtil.fillFrom(answer, orig);
        return answer;
    }

    public static DNode from(Node orig) {
        return null;
    }

    public static DNotation from(Notation orig) {
        DNotation answer = new DNotation(null, orig.getNodeName());
        DomUtil.fillFrom(answer, orig);
        answer.setPublicId(orig.getPublicId());
        answer.setSystemId(orig.getSystemId());
        return answer;
    }

    public static DDocumentType from(DocumentType orig) {
        DDocumentType answer = new DDocumentType(orig.getName(), orig.getPublicId(), orig.getSystemId());
        DomUtil.fillFrom(answer, orig);
        answer.setInternalSubset(orig.getInternalSubset());
        NamedNodeMap map = orig.getEntities();
        int len = map.getLength();
        int i = 0;
        while (i < len) {
            Entity entity = (Entity)map.item(i);
            DEntity newEntity = DomUtil.from(entity);
            answer.getEntities().setNamedItem(newEntity);
            ++i;
        }
        map = orig.getNotations();
        len = map.getLength();
        i = 0;
        while (i < len) {
            Notation notation = (Notation)map.item(i);
            DNotation newNotation = DomUtil.from(notation);
            answer.getNotations().setNamedItem(newNotation);
            ++i;
        }
        return answer;
    }

    public static DEntity from(Entity orig) {
        DEntity answer = new DEntity(null, orig.getNodeName());
        DomUtil.fillFrom(answer, orig);
        answer.setInputEncoding(orig.getInputEncoding());
        answer.setXmlEncoding(orig.getXmlEncoding());
        answer.setXmlVersion(orig.getXmlVersion());
        answer.setPublicId(orig.getPublicId());
        answer.setSystemId(orig.getSystemId());
        return answer;
    }

    public static DNamespace getNamespace(String uri, String possibleQualifiedName) {
        int colonIndex = possibleQualifiedName.indexOf(":");
        if (colonIndex == -1) {
            return DNamespace.getNamespace(uri, possibleQualifiedName);
        }
        String prefix = possibleQualifiedName.substring(0, colonIndex);
        return DNamespace.getNamespace(uri, prefix);
    }

    public static String getUnqualifedName(String possibleQualifiedName) {
        int colonIndex = possibleQualifiedName.indexOf(":");
        if (colonIndex == -1) {
            return possibleQualifiedName;
        }
        return possibleQualifiedName.substring(colonIndex + 1);
    }
}

