/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.node.visitor;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.vjet.dsf.common.node.IDNodeList;
import org.eclipse.vjet.dsf.common.node.visitor.DNodeVisitStatus;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeHandlingStrategy;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeVisitor;
import org.eclipse.vjet.dsf.common.phase.PhaseId;
import org.eclipse.vjet.dsf.dom.DNode;

public class BreadthFirstDNodeTraversal
implements IDNodeHandlingStrategy {
    private PhaseId m_phaseId = PhaseId.ANY_PHASE;
    private List<DNode> m_kidsToTraverse = new LinkedList<DNode>();

    @Override
    public PhaseId getApplicablePhaseId() {
        return this.m_phaseId;
    }

    public void setApplicablePhaseId(PhaseId phaseId) {
        this.m_phaseId = phaseId;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BreadthFirstDNodeTraversal copy = new BreadthFirstDNodeTraversal();
        copy.m_phaseId = this.m_phaseId;
        return copy;
    }

    @Override
    public void handle(DNode current, IDNodeVisitor visitor) {
        boolean stopTraversal;
        int numKidsToTraverse = this.m_kidsToTraverse.size();
        DNodeVisitStatus status = visitor.preVisit(current);
        boolean bl = stopTraversal = status == DNodeVisitStatus.STOP_SUBTREE_TRAVERSAL;
        if (status != DNodeVisitStatus.ABORT_CURRENT_NODE || status != DNodeVisitStatus.ABORT_SUBTREE) {
            status = visitor.visit(current);
        }
        if (!stopTraversal && status != DNodeVisitStatus.ABORT_SUBTREE && status != DNodeVisitStatus.STOP_SUBTREE_TRAVERSAL) {
            this.collectChildren(current);
        }
        if (status != DNodeVisitStatus.ABORT_CURRENT_NODE || status != DNodeVisitStatus.ABORT_SUBTREE) {
            visitor.postVisit(current);
        }
        if (numKidsToTraverse == 0) {
            this.startNextLevel(visitor);
        }
    }

    protected void collectChildren(DNode node) {
        if (node.hasDsfFacets()) {
            Iterator itr = node.getDsfFacets().iterator();
            while (itr.hasNext()) {
                this.m_kidsToTraverse.add((DNode)itr.next());
            }
        }
        if (node.hasChildNodes()) {
            IDNodeList children = node.getDsfChildNodes();
            int len = children.getLength();
            int i = 0;
            while (i < len) {
                this.m_kidsToTraverse.add((DNode)children.get(i));
                ++i;
            }
        }
    }

    private void startNextLevel(IDNodeVisitor visitor) {
        int numKids = this.m_kidsToTraverse.size();
        int i = 0;
        while (i < numKids) {
            DNode child = this.m_kidsToTraverse.remove(0);
            child.dsfAccept(visitor);
            ++i;
        }
        if (this.m_kidsToTraverse.size() > 0) {
            this.startNextLevel(visitor);
        }
    }
}

