/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.css.dom.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.eclipse.vjet.dsf.css.dom.impl.DCssException;
import org.eclipse.vjet.dsf.css.dom.impl.DCssRule;
import org.eclipse.vjet.dsf.css.parser.DCssBuilder;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;

public class DCssFontFaceRule
extends DCssRule
implements CSSFontFaceRule,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private CSSStyleDeclaration m_style = null;

    public DCssFontFaceRule(CSSStyleSheet parentStyleSheet, CSSRule parentRule) {
        super(parentStyleSheet, parentRule);
    }

    @Override
    public short getType() {
        return 5;
    }

    @Override
    public String getCssText() {
        return "@font-face " + this.getStyle().getCssText();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        if (this.m_parentStyleSheet != null) {
            throw new DCssException(7, 2);
        }
        try {
            InputSource is = new InputSource((Reader)new StringReader(cssText));
            DCssBuilder parser = new DCssBuilder();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 5) {
                throw new DCssException(13, 8);
            }
            this.m_style = ((DCssFontFaceRule)r).m_style;
        }
        catch (DCssException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
    }

    @Override
    public CSSStyleDeclaration getStyle() {
        return this.m_style;
    }

    public CSSFontFaceRule setStyle(CSSStyleDeclaration style) {
        this.m_style = style;
        return this;
    }

    public String toString() {
        return this.getCssText();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

