/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchConfigurationWorkingCopy;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.dbgp.DbgpSessionIdGenerator;
import org.eclipse.dltk.mod.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.mod.debug.core.IDbgpService;
import org.eclipse.dltk.mod.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptDebugTarget;
import org.eclipse.dltk.mod.launching.InterpreterConfig;
import org.eclipse.jdt.internal.launching.JavaSourceLookupDirector;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.internal.debug.VjetDebugPlugin;
import org.eclipse.vjet.eclipse.internal.debug.debugger.VjetDebugEngineRunner;
import org.eclipse.vjet.eclipse.internal.launching.GenericVjetInstallType;
import org.eclipse.vjet.eclipse.internal.launching.SourceLocatorProxy;
import org.eclipse.vjet.eclipse.internal.launching.VjetSourceLookupDirector;
import org.eclipse.vjet.eclipse.launching.VjetLaunchingPlugin;

public class LaunchListener
implements ILaunchListener {
    private static final String JAVA_APPLICATION_LAUNCH_TYPE = "org.eclipse.jdt.launching.localJavaApplication";
    private static final String DERVLET_APPLICATION_LAUNCH_TYPE = "com.ebay.darwin.tools.eclipse.plugin.launcher.dervlet";
    private static final String JSUNIT_LAUNCH_TYPE = "com.ebay.darwin.tools.eclipse.plugin.launcher.jsunit";
    private static final String[] ATTACHABLE_LAUNCH_TYPES = new String[]{"org.eclipse.jdt.launching.localJavaApplication", "com.ebay.darwin.tools.eclipse.plugin.launcher.dervlet", "com.ebay.darwin.tools.eclipse.plugin.launcher.jsunit"};

    public void launchRemoved(ILaunch launch) {
    }

    public void launchAdded(ILaunch launch) {
        if (!"debug".equals(launch.getLaunchMode())) {
            return;
        }
        try {
            boolean attachDebugger = VjetDebugPlugin.getDefault().getPreferenceStore().getBoolean("dbgp_java_based_project_attachment");
            if (!attachDebugger) {
                return;
            }
            ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
            String launchTypeId = launchConfiguration.getType().getIdentifier();
            if (!this.canAttachVjetDebugger(launchTypeId)) {
                return;
            }
            String projectName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            IScriptProject sp = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getScriptProject(projectName);
            EnvironmentManager.getEnvironment((IModelElement)sp);
            ILaunchConfiguration config = launchConfiguration;
            LaunchWorkingCopy copy = new LaunchWorkingCopy((LaunchConfiguration)config);
            boolean breakOnFirstLine = VjetDebugPlugin.getDefault().getPreferenceStore().getBoolean("dbgp_java_based_break_first_line");
            copy.setAttribute("enableBreakOnFirstLine", breakOnFirstLine);
            boolean useInteractiveConsole = VjetDebugPlugin.getDefault().getPreferenceStore().getBoolean("dbgp_java_based_use_interactive_console");
            copy.setAttribute("use_dltk_interactive_console", useInteractiveConsole);
            copy.setAttribute("console_id", Long.toString(System.currentTimeMillis()));
            copy.setAttribute("dbgp_remote", true);
            copy.setAttribute("project", projectName);
            copy.setAttribute("org.eclipse.dltk.mod.debug.debugConsole", Boolean.TRUE.toString());
            copy.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", null);
            copy.setAttribute("debugging_engine_id", "org.eclipse.vjet.eclipse.debug");
            boolean enableDbgpLogging = VjetDebugPlugin.getDefault().getPreferenceStore().getBoolean("dbgp_java_based_enable_dbgp_logging");
            copy.setAttribute("enableDbgpLogging", enableDbgpLogging);
            copy.doSave();
            config = launchConfiguration;
            VjetDebugEngineRunner debugEngine = new VjetDebugEngineRunner(new GenericVjetInstallType().createInterpreterInstall("org.eclipse.vjet.eclipse.launching.embeddedRhino"));
            debugEngine.run(new InterpreterConfig(), launch, null);
        }
        catch (Exception e) {
            VjetLaunchingPlugin.error((String)"Failed to start VJET debugger.", (Throwable)e, (int)2);
        }
    }

    private boolean canAttachVjetDebugger(String launchTypeId) {
        String[] stringArray = ATTACHABLE_LAUNCH_TYPES;
        int n = ATTACHABLE_LAUNCH_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.equals(launchTypeId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void setUpSourceLocator(ILaunch launch) {
        ISourceLocator origLocator = launch.getSourceLocator();
        if (origLocator == null || origLocator instanceof SourceLocatorProxy) {
            return;
        }
        if (origLocator instanceof VjetSourceLookupDirector) {
            return;
        }
        if (origLocator instanceof JavaSourceLookupDirector) {
            launch.setSourceLocator((ISourceLocator)this.getSourceLocator(launch, origLocator));
        }
    }

    private SourceLocatorProxy getSourceLocator(ILaunch launch, ISourceLocator origLocator) {
        SourceLocatorProxy sourceLocator = new SourceLocatorProxy(origLocator, (ISourceLocator)new VjetSourceLookupDirector());
        try {
            sourceLocator.initializeDefaults(launch.getLaunchConfiguration());
        }
        catch (CoreException e) {
            VjetPlugin.error((String)e.getLocalizedMessage(), (Throwable)e);
        }
        sourceLocator.initializeParticipants();
        return sourceLocator;
    }

    private IProject getProjectFromLaunch(ILaunch launch) {
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        IProject launchProject = null;
        try {
            String projectName = launchConfiguration.getAttribute("org.eclipse.jdt.launching.PROJECT_ATTR", "");
            if (projectName != null && projectName.length() > 0) {
                launchProject = LaunchListener.getWorkspaceProject(projectName);
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        if (launchProject == null) {
            return null;
        }
        return launchProject;
    }

    public static IProject getWorkspaceProject(String projectName) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject codeGenProject = workspace.getRoot().getProject(projectName);
        if (codeGenProject != null && !codeGenProject.isOpen()) {
            codeGenProject.open(null);
        }
        return codeGenProject;
    }

    private IScriptDebugTarget installScriptDebugTarget(ILaunch launch, IDbgpService service) {
        try {
            String modelID = "org.eclipse.vjet.eclipse.debug.vjetModel";
            String sessionID = DbgpSessionIdGenerator.generate();
            ScriptDebugTarget scriptDebugTarget = new ScriptDebugTarget(modelID, service, sessionID, launch, null);
            launch.addDebugTarget((IDebugTarget)scriptDebugTarget);
            launch.getSourceLocator();
            return scriptDebugTarget;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setSystemProperties(IScriptDebugTarget scriptDebugTarget, IDbgpService service) {
        int port = service.getPort();
        System.setProperty("-DVJETDebugPort", String.valueOf(port));
        String host = DLTKDebugPlugin.getDefault().getBindAddress();
        System.setProperty("-DVJETDebugHost", host);
        String debugID = scriptDebugTarget.getSessionId();
        System.setProperty("-DVJETDebugDebugID", debugID);
    }

    public void launchChanged(ILaunch launch) {
        if (!"debug".equals(launch.getLaunchMode())) {
            return;
        }
        boolean attachDebugger = VjetDebugPlugin.getDefault().getPreferenceStore().getBoolean("dbgp_java_based_project_attachment");
        if (!attachDebugger) {
            return;
        }
        this.setUpSourceLocator(launch);
    }

    class LaunchWorkingCopy
    extends LaunchConfigurationWorkingCopy {
        protected LaunchWorkingCopy(LaunchConfiguration original) throws CoreException {
            super(original);
        }
    }
}

