/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.debug.core.model;

import java.net.URI;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.dbgp.IDbgpSession;
import org.eclipse.dltk.mod.dbgp.IDbgpSpawnpoint;
import org.eclipse.dltk.mod.dbgp.breakpoints.DbgpBreakpointConfig;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpBreakpointCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpSpawnpointCommands;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.mod.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.mod.debug.core.DebugOption;
import org.eclipse.dltk.mod.debug.core.IDLTKDebugToolkit;
import org.eclipse.dltk.mod.debug.core.ScriptDebugManager;
import org.eclipse.dltk.mod.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.mod.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.mod.debug.core.model.IScriptExceptionBreakpoint;
import org.eclipse.dltk.mod.debug.core.model.IScriptLineBreakpoint;
import org.eclipse.dltk.mod.debug.core.model.IScriptMethodEntryBreakpoint;
import org.eclipse.dltk.mod.debug.core.model.IScriptSpawnpoint;
import org.eclipse.dltk.mod.debug.core.model.IScriptThread;
import org.eclipse.dltk.mod.debug.core.model.IScriptWatchpoint;
import org.eclipse.dltk.mod.internal.debug.core.model.IScriptBreakpointPathMapper;
import org.eclipse.dltk.mod.internal.debug.core.model.Messages;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptBreakpointUtils;
import org.eclipse.osgi.util.NLS;

public class ScriptBreakpointManager
implements IBreakpointListener,
IBreakpointManagerListener {
    private final IScriptBreakpointPathMapper bpPathMapper;
    private static final int NO_CHANGES = 0;
    private static final int MINOR_CHANGE = 1;
    private static final int MAJOR_CHANGE = 2;
    private final IScriptDebugTarget target;

    protected static IBreakpointManager getBreakpointManager() {
        return DebugPlugin.getDefault().getBreakpointManager();
    }

    protected static DbgpBreakpointConfig createBreakpointConfig(IScriptBreakpoint breakpoint) throws CoreException {
        boolean enabled = breakpoint.isEnabled() && ScriptBreakpointManager.getBreakpointManager().isEnabled();
        DbgpBreakpointConfig config = new DbgpBreakpointConfig(enabled);
        config.setHitValue(breakpoint.getHitValue());
        config.setHitCondition(breakpoint.getHitCondition());
        if (breakpoint.getExpressionState()) {
            config.setExpression(breakpoint.getExpression());
        }
        if (breakpoint instanceof IScriptLineBreakpoint && !(breakpoint instanceof IScriptMethodEntryBreakpoint)) {
            IScriptLineBreakpoint lineBreakpoint = (IScriptLineBreakpoint)breakpoint;
            config.setLineNo(lineBreakpoint.getLineNumber());
        }
        return config;
    }

    protected static String makeWatchpointExpression(IScriptWatchpoint watchpoint) throws CoreException {
        IDLTKDebugToolkit debugToolkit = ScriptDebugManager.getInstance().getDebugToolkitByDebugModel(watchpoint.getModelIdentifier());
        if (debugToolkit.isAccessWatchpointSupported()) {
            return String.valueOf(watchpoint.getFieldName()) + (watchpoint.isAccess() ? (char)'1' : '0') + (watchpoint.isModification() ? (char)'1' : '0');
        }
        return watchpoint.getFieldName();
    }

    protected void addBreakpoint(IDbgpCoreCommands commands, IScriptBreakpoint breakpoint) throws CoreException, DbgpException {
        IScriptBreakpoint lineBreakpoint;
        DbgpBreakpointConfig config = ScriptBreakpointManager.createBreakpointConfig(breakpoint);
        String id = null;
        URI bpUri = null;
        if (breakpoint instanceof IScriptLineBreakpoint) {
            IScriptLineBreakpoint bp = (IScriptLineBreakpoint)breakpoint;
            bpUri = this.bpPathMapper.map(bp.getResourceURI());
        }
        if (breakpoint instanceof IScriptWatchpoint) {
            IScriptWatchpoint watchpoint = (IScriptWatchpoint)breakpoint;
            config.setExpression(ScriptBreakpointManager.makeWatchpointExpression(watchpoint));
            id = commands.setWatchBreakpoint(bpUri, watchpoint.getLineNumber(), config);
        } else if (breakpoint instanceof IScriptMethodEntryBreakpoint) {
            IScriptMethodEntryBreakpoint entryBreakpoint = (IScriptMethodEntryBreakpoint)breakpoint;
            if (entryBreakpoint.breakOnExit()) {
                String exitId = commands.setReturnBreakpoint(bpUri, entryBreakpoint.getMethodName(), config);
                entryBreakpoint.setExitBreakpointId(exitId);
            }
            if (entryBreakpoint.breakOnEntry()) {
                String entryId = commands.setCallBreakpoint(bpUri, entryBreakpoint.getMethodName(), config);
                entryBreakpoint.setEntryBreakpointId(entryId);
            }
        } else if (breakpoint instanceof IScriptLineBreakpoint) {
            lineBreakpoint = (IScriptLineBreakpoint)breakpoint;
            id = ScriptBreakpointUtils.isConditional(lineBreakpoint) ? commands.setConditionalBreakpoint(bpUri, lineBreakpoint.getLineNumber(), config) : commands.setLineBreakpoint(bpUri, lineBreakpoint.getLineNumber(), config);
        } else if (breakpoint instanceof IScriptExceptionBreakpoint) {
            lineBreakpoint = (IScriptExceptionBreakpoint)breakpoint;
            id = commands.setExceptionBreakpoint(lineBreakpoint.getTypeName(), config);
        }
        breakpoint.setIdentifier(id);
    }

    private void addSpawnpoint(IDbgpSpawnpointCommands commands, IScriptSpawnpoint spawnpoint) throws DbgpException, CoreException {
        IDbgpSpawnpoint p = commands.setSpawnpoint(this.bpPathMapper.map(spawnpoint.getResourceURI()), spawnpoint.getLineNumber(), spawnpoint.isEnabled());
        if (p != null) {
            spawnpoint.setIdentifier(p.getId());
        }
    }

    private void addSpawnpoint(IScriptSpawnpoint spawnpoint) throws DbgpException, CoreException {
        IDbgpSession session;
        if (this.supportsBreakpoint(spawnpoint) && (session = this.getSession()) != null) {
            this.addSpawnpoint((IDbgpSpawnpointCommands)session.get(IDbgpSpawnpointCommands.class), spawnpoint);
        }
    }

    protected void changeBreakpoint(IDbgpBreakpointCommands commands, IScriptBreakpoint breakpoint) throws DbgpException, CoreException {
        URI bpUri = null;
        if (breakpoint instanceof IScriptLineBreakpoint) {
            IScriptLineBreakpoint bp = (IScriptLineBreakpoint)breakpoint;
            bpUri = this.bpPathMapper.map(bp.getResourceURI());
        }
        if (breakpoint instanceof IScriptMethodEntryBreakpoint) {
            DbgpBreakpointConfig config = ScriptBreakpointManager.createBreakpointConfig(breakpoint);
            IScriptMethodEntryBreakpoint entryBreakpoint = (IScriptMethodEntryBreakpoint)breakpoint;
            String entryId = entryBreakpoint.getEntryBreakpointId();
            if (entryBreakpoint.breakOnEntry()) {
                if (entryId == null) {
                    entryId = commands.setCallBreakpoint(bpUri, entryBreakpoint.getMethodName(), config);
                    entryBreakpoint.setEntryBreakpointId(entryId);
                } else {
                    commands.updateBreakpoint(entryId, config);
                }
            } else if (entryId != null) {
                commands.removeBreakpoint(entryId);
                entryBreakpoint.setEntryBreakpointId(null);
            }
            String exitId = entryBreakpoint.getExitBreakpointId();
            if (entryBreakpoint.breakOnExit()) {
                if (exitId == null) {
                    exitId = commands.setReturnBreakpoint(bpUri, entryBreakpoint.getMethodName(), config);
                    entryBreakpoint.setExitBreakpointId(exitId);
                } else {
                    commands.updateBreakpoint(exitId, config);
                }
            } else if (exitId != null) {
                commands.removeBreakpoint(exitId);
                entryBreakpoint.setExitBreakpointId(null);
            }
        } else {
            String id = breakpoint.getIdentifier();
            DbgpBreakpointConfig config = ScriptBreakpointManager.createBreakpointConfig(breakpoint);
            if (breakpoint instanceof IScriptWatchpoint) {
                config.setExpression(ScriptBreakpointManager.makeWatchpointExpression((IScriptWatchpoint)breakpoint));
            }
            commands.updateBreakpoint(id, config);
        }
    }

    protected static void removeBreakpoint(IDbgpBreakpointCommands commands, IScriptBreakpoint breakpoint) throws DbgpException, CoreException {
        commands.removeBreakpoint(breakpoint.getIdentifier());
        breakpoint.setIdentifier(null);
        if (breakpoint instanceof IScriptMethodEntryBreakpoint) {
            String exitId;
            IScriptMethodEntryBreakpoint entryBreakpoint = (IScriptMethodEntryBreakpoint)breakpoint;
            String entryId = entryBreakpoint.getEntryBreakpointId();
            if (entryId != null) {
                commands.removeBreakpoint(entryId);
            }
            if ((exitId = entryBreakpoint.getExitBreakpointId()) != null) {
                commands.removeBreakpoint(exitId);
            }
        }
    }

    private int hasBreakpointChanges(IMarkerDelta delta, IScriptBreakpoint breakpoint) {
        String[] attrs = breakpoint.getUpdatableAttributes();
        try {
            IMarker marker = delta.getMarker();
            int i = 0;
            while (i < attrs.length) {
                String attr = attrs[i];
                Object oldValue = delta.getAttribute(attr);
                Object newValue = marker.getAttribute(attr);
                if (oldValue == null) {
                    if (newValue != null) {
                        return this.classifyBreakpointChange(delta, breakpoint, attr);
                    }
                } else {
                    if (newValue == null) {
                        return this.classifyBreakpointChange(delta, breakpoint, attr);
                    }
                    if (!oldValue.equals(newValue)) {
                        return this.classifyBreakpointChange(delta, breakpoint, attr);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
        }
        return 0;
    }

    private static int hasSpawnpointChanges(IMarkerDelta delta, IScriptBreakpoint breakpoint) {
        String[] attrs = breakpoint.getUpdatableAttributes();
        try {
            IMarker marker = delta.getMarker();
            int i = 0;
            while (i < attrs.length) {
                String attr = attrs[i];
                if ("org.eclipse.debug.core.enabled".equals(attr) || "lineNumber".equals(attr)) {
                    Object oldValue = delta.getAttribute(attr);
                    Object newValue = marker.getAttribute(attr);
                    if (oldValue == null) {
                        if (newValue != null) {
                            return "lineNumber".equals(attr) ? 2 : 1;
                        }
                    } else {
                        if (newValue == null) {
                            return "lineNumber".equals(attr) ? 2 : 1;
                        }
                        if (!oldValue.equals(newValue)) {
                            return "lineNumber".equals(attr) ? 2 : 1;
                        }
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
        }
        return 0;
    }

    private int classifyBreakpointChange(IMarkerDelta delta, IScriptBreakpoint breakpoint, String attr) throws CoreException {
        String oldExpr;
        boolean conditional = ScriptBreakpointUtils.isConditional(breakpoint);
        if (conditional && "org.eclipse.dltk.mod.debug.expression".equals(attr)) {
            return 2;
        }
        boolean oldExprState = delta.getAttribute("org.eclipse.dltk.mod.debug.expression.state", false);
        if (ScriptBreakpointUtils.isConditional(oldExprState, oldExpr = delta.getAttribute("org.eclipse.dltk.mod.debug.expression", null)) != conditional) {
            return 2;
        }
        if ("lineNumber".equals(attr) && !this.target.getOptions().get(DebugOption.DBGP_BREAKPOINT_UPDATE_LINE_NUMBER)) {
            return 2;
        }
        return 1;
    }

    protected void addBreakpoint(IBreakpoint breakpoint) throws CoreException, DbgpException {
        IDbgpSession session;
        if (this.supportsBreakpoint(breakpoint) && (session = this.getSession()) != null) {
            if (breakpoint instanceof IScriptSpawnpoint) {
                this.addSpawnpoint((IDbgpSpawnpointCommands)session.get(IDbgpSpawnpointCommands.class), (IScriptSpawnpoint)breakpoint);
            } else {
                this.addBreakpoint(session.getCoreCommands(), (IScriptBreakpoint)breakpoint);
            }
        }
    }

    protected void changeBreakpoint(IBreakpoint breakpoint) throws CoreException, DbgpException {
        IDbgpSession session;
        if (this.supportsBreakpoint(breakpoint) && (session = this.getSession()) != null) {
            this.changeBreakpoint(session.getCoreCommands(), (IScriptBreakpoint)breakpoint);
        }
    }

    private void changeSpawnpoint(IScriptSpawnpoint spawnpoint) throws DbgpException, CoreException {
        IDbgpSpawnpointCommands commands;
        IDbgpSession session;
        if (this.supportsBreakpoint(spawnpoint) && (session = this.getSession()) != null && (commands = (IDbgpSpawnpointCommands)session.get(IDbgpSpawnpointCommands.class)) != null) {
            commands.updateSpawnpoint(spawnpoint.getIdentifier(), spawnpoint.isEnabled());
        }
    }

    protected void removeBreakpoint(IBreakpoint breakpoint) throws CoreException, DbgpException {
        IDbgpSession session;
        if (this.supportsBreakpoint(breakpoint) && (session = this.getSession()) != null) {
            ScriptBreakpointManager.removeBreakpoint(session.getCoreCommands(), (IScriptBreakpoint)breakpoint);
        }
    }

    protected void removeSpawnpoint(IScriptSpawnpoint spawnpoint) throws DbgpException, CoreException {
        IDbgpSpawnpointCommands commands;
        IDbgpSession session;
        if (this.supportsBreakpoint(spawnpoint) && (session = this.getSession()) != null && (commands = (IDbgpSpawnpointCommands)session.get(IDbgpSpawnpointCommands.class)) != null) {
            commands.removeSpawnpoint(spawnpoint.getIdentifier());
            spawnpoint.setIdentifier(null);
        }
    }

    private IDbgpSession getSession() throws DebugException {
        IScriptThread[] threads = (IScriptThread[])this.target.getThreads();
        if (threads.length > 0) {
            return threads[0].getDbgpSession();
        }
        return null;
    }

    public ScriptBreakpointManager(IScriptDebugTarget target, IScriptBreakpointPathMapper pathMapper) {
        this.target = target;
        this.bpPathMapper = pathMapper;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint instanceof IScriptBreakpoint) {
            String modelId = this.target.getModelIdentifier();
            String breakpointModelId = breakpoint.getModelIdentifier();
            return breakpointModelId.equals(modelId);
        }
        return false;
    }

    public void threadAccepted() {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        manager.addBreakpointListener((IBreakpointListener)this.target);
        manager.addBreakpointManagerListener((IBreakpointManagerListener)this);
    }

    public void threadTerminated() {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        manager.removeBreakpointListener((IBreakpointListener)this.target);
        manager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
        this.bpPathMapper.clearCache();
    }

    public void setupDeferredBreakpoints() {
        IBreakpoint[] breakpoints = ScriptBreakpointManager.getBreakpointManager().getBreakpoints(this.target.getModelIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            block3: {
                try {
                    this.addBreakpoint(breakpoints[i]);
                }
                catch (Exception e) {
                    DLTKDebugPlugin.logError(NLS.bind((String)Messages.ErrorSetupDeferredBreakpoints, (Object)e.toString()), e);
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public String addBreakpoint(URI uri, int line) {
        try {
            IDbgpSession session = this.getSession();
            if (session != null) {
                DbgpBreakpointConfig config = new DbgpBreakpointConfig(true);
                return session.getCoreCommands().setLineBreakpoint(uri, line, config);
            }
        }
        catch (DebugException e) {
            DLTKDebugPlugin.log(e);
        }
        catch (DbgpException e) {
            DLTKDebugPlugin.log(e);
        }
        return null;
    }

    public void removeBreakpoint(String id) {
        try {
            IDbgpSession session = this.getSession();
            if (session != null) {
                session.getCoreCommands().removeBreakpoint(id);
            }
        }
        catch (DebugException e) {
            DLTKDebugPlugin.log(e);
        }
        catch (DbgpException e) {
            DLTKDebugPlugin.log(e);
        }
    }

    public void setBreakpointUntilFirstSuspend(URI uri, int line) {
        final String tempId = this.addBreakpoint(uri, line);
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    if (event.getKind() == 2) {
                        ScriptBreakpointManager.this.removeBreakpoint(tempId);
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    }
                    ++i;
                }
            }
        });
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        try {
            this.addBreakpoint(breakpoint);
        }
        catch (Exception e) {
            DLTKDebugPlugin.log(e);
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        try {
            if (breakpoint instanceof IScriptBreakpoint && delta != null) {
                if (breakpoint instanceof IScriptSpawnpoint) {
                    int changes = ScriptBreakpointManager.hasSpawnpointChanges(delta, (IScriptSpawnpoint)breakpoint);
                    if (changes != 0) {
                        if (changes == 2) {
                            this.removeSpawnpoint((IScriptSpawnpoint)breakpoint);
                            this.addSpawnpoint((IScriptSpawnpoint)breakpoint);
                        } else {
                            this.changeSpawnpoint((IScriptSpawnpoint)breakpoint);
                        }
                    }
                } else {
                    int changes = this.hasBreakpointChanges(delta, (IScriptBreakpoint)breakpoint);
                    if (changes != 0) {
                        if (changes == 2) {
                            this.removeBreakpoint(breakpoint);
                            this.addBreakpoint(breakpoint);
                        } else {
                            this.changeBreakpoint(breakpoint);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            DLTKDebugPlugin.log(e);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        try {
            if (breakpoint instanceof IScriptSpawnpoint) {
                this.removeSpawnpoint((IScriptSpawnpoint)breakpoint);
            } else {
                this.removeBreakpoint(breakpoint);
            }
        }
        catch (Exception e) {
            DLTKDebugPlugin.log(e);
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        IBreakpointManager manager = ScriptBreakpointManager.getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(this.target.getModelIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            try {
                IBreakpoint breakpoint = breakpoints[i];
                if (breakpoint instanceof IScriptSpawnpoint) {
                    this.changeSpawnpoint((IScriptSpawnpoint)breakpoint);
                } else {
                    this.changeBreakpoint(breakpoint);
                }
            }
            catch (Exception e) {
                DLTKDebugPlugin.log(e);
            }
            ++i;
        }
    }
}

