/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Scale
extends Control {
    public Scale(Composite parent, int style) {
        super(parent, Scale.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Scale.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if ((this.style & 0x100) != 0) {
            if (wHint == -1) {
                size.x = 2 * size.x;
            }
        } else if (hHint == -1) {
            size.y = 2 * size.y;
        }
        return size;
    }

    @Override
    void createHandle(int index) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        long hAdjustment = OS.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 0.0);
        if (hAdjustment == 0L) {
            this.error(2);
        }
        this.handle = (this.style & 0x100) != 0 ? this.gtk_scale_new(0, hAdjustment) : this.gtk_scale_new(1, hAdjustment);
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        OS.gtk_scale_set_digits(this.handle, 0);
        OS.gtk_scale_set_draw_value(this.handle, false);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.value_changed, this.display.getClosure(57), false);
    }

    public int getIncrement() {
        this.checkWidget();
        long hAdjustment = OS.gtk_range_get_adjustment(this.handle);
        return (int)OS.gtk_adjustment_get_step_increment(hAdjustment);
    }

    public int getMaximum() {
        this.checkWidget();
        long hAdjustment = OS.gtk_range_get_adjustment(this.handle);
        return (int)OS.gtk_adjustment_get_upper(hAdjustment);
    }

    public int getMinimum() {
        this.checkWidget();
        long hAdjustment = OS.gtk_range_get_adjustment(this.handle);
        return (int)OS.gtk_adjustment_get_lower(hAdjustment);
    }

    public int getPageIncrement() {
        this.checkWidget();
        long hAdjustment = OS.gtk_range_get_adjustment(this.handle);
        return (int)OS.gtk_adjustment_get_page_increment(hAdjustment);
    }

    public int getSelection() {
        this.checkWidget();
        long hAdjustment = OS.gtk_range_get_adjustment(this.handle);
        return (int)OS.gtk_adjustment_get_value(hAdjustment);
    }

    @Override
    long gtk_value_changed(long adjustment) {
        this.sendSelectionEvent(13);
        return 0L;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setIncrement(int increment) {
        this.checkWidget();
        if (increment < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_range_set_increments(this.handle, increment, this.getPageIncrement());
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        int minimum = this.getMinimum();
        if (value <= minimum) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_range_set_range(this.handle, minimum, value);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int maximum = this.getMaximum();
        if (value >= maximum) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_range_set_range(this.handle, value, maximum);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setPageIncrement(int pageIncrement) {
        this.checkWidget();
        if (pageIncrement < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_range_set_increments(this.handle, this.getIncrement(), pageIncrement);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_range_set_value(this.handle, value);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    long gtk_scale_new(int orientation, long adjustment) {
        long scale = 0L;
        scale = OS.GTK3 ? OS.gtk_scale_new(orientation, adjustment) : (orientation == 0 ? OS.gtk_hscale_new(adjustment) : OS.gtk_vscale_new(adjustment));
        return scale;
    }
}

