/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.include;

import java.util.Arrays;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.DefineSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.include.DefineDataContentProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.include.DefineDataLabelProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.include.DefineItemTransfer;
import org.eclipse.titan.designer.editors.configeditor.pages.include.DefineSectionDragSourceListener;
import org.eclipse.titan.designer.editors.configeditor.pages.include.DefineSectionDropTargetListener;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public final class DefineSubPage {
    private Label totalDefineElementsLabel;
    private Table defineElementsTable;
    private TableViewer defineElementsTableViewer;
    private Button add;
    private Button remove;
    private static final String[] COLUMN_NAMES = new String[]{"definitionName", "definitionValue"};
    private final ConfigEditor editor;
    private DefineSectionHandler defineSectionHandler;

    public DefineSubPage(ConfigEditor editor) {
        this.editor = editor;
    }

    void createDefinitionSection(Composite parent, final ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 386);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        toolkit.paintBordersFor(client);
        this.defineElementsTable = toolkit.createTable(client, 66306);
        this.defineElementsTable.setEnabled(this.defineSectionHandler != null);
        TableColumn column = new TableColumn(this.defineElementsTable, 16384, 0);
        column.setText("Definition name");
        column.setMoveable(false);
        column.setWidth(150);
        column = new TableColumn(this.defineElementsTable, 16384, 1);
        column.setText("Definition value");
        column.setWidth(300);
        column.setMoveable(false);
        this.defineElementsTable.setHeaderVisible(true);
        this.defineElementsTable.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        gd.heightHint = 200;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.defineElementsTable.setLayoutData((Object)gd);
        Composite buttons = toolkit.createComposite(client);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(1026));
        this.add = toolkit.createButton(buttons, "Add...", 8);
        gd = new GridData(258);
        this.add.setLayoutData((Object)gd);
        this.add.setEnabled(this.defineSectionHandler != null);
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DefineSectionHandler.Definition newItem;
                if (DefineSubPage.this.defineSectionHandler == null) {
                    return;
                }
                if (DefineSubPage.this.defineSectionHandler.getLastSectionRoot() == null) {
                    DefineSubPage.this.createNewDefineSection();
                }
                if ((newItem = DefineSubPage.this.createNewDefineItem()) == null) {
                    return;
                }
                ConfigTreeNodeUtilities.addChild((ParseTree)DefineSubPage.this.defineSectionHandler.getLastSectionRoot(), (ParseTree)newItem.getRoot());
                DefineSubPage.this.defineSectionHandler.getDefinitions().add(newItem);
                DefineSubPage.this.internalRefresh();
                DefineSubPage.this.defineElementsTable.select(DefineSubPage.this.defineSectionHandler.getDefinitions().size() - 1);
                DefineSubPage.this.defineElementsTable.showSelection();
                DefineSubPage.this.editor.setDirty();
            }
        });
        this.remove = toolkit.createButton(buttons, "Remove", 8);
        gd = new GridData(258);
        this.remove.setLayoutData((Object)gd);
        this.remove.setEnabled(this.defineSectionHandler != null);
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (DefineSubPage.this.defineElementsTableViewer == null || DefineSubPage.this.defineSectionHandler == null) {
                    return;
                }
                DefineSubPage.this.removeSelectedDefineItems();
                if (DefineSubPage.this.defineSectionHandler.getDefinitions().isEmpty()) {
                    DefineSubPage.this.removeDefineSection();
                }
                DefineSubPage.this.internalRefresh();
                DefineSubPage.this.editor.setDirty();
            }
        });
        this.totalDefineElementsLabel = toolkit.createLabel(buttons, "Total defined: 0");
        gd = new GridData(258);
        this.totalDefineElementsLabel.setLayoutData((Object)gd);
        section.setText("Definitions");
        section.setDescription("Specify the list of Definitions for this configuration.");
        section.setClient((Control)client);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        gd = new GridData(1808);
        section.setLayoutData((Object)gd);
        this.defineElementsTableViewer = new TableViewer(this.defineElementsTable);
        this.defineElementsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this.defineElementsTableViewer.setContentProvider((IContentProvider)new DefineDataContentProvider());
        this.defineElementsTableViewer.setLabelProvider((IBaseLabelProvider)new DefineDataLabelProvider());
        this.defineElementsTableViewer.setInput((Object)this.defineSectionHandler);
        this.defineElementsTableViewer.setColumnProperties(COLUMN_NAMES);
        this.defineElementsTableViewer.setCellEditors((CellEditor[])new TextCellEditor[]{new TextCellEditor((Composite)this.defineElementsTable), new TextCellEditor((Composite)this.defineElementsTable)});
        this.defineElementsTableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public String getValue(Object element, String property) {
                int columnIndex = Arrays.asList(COLUMN_NAMES).indexOf(property);
                DefineDataLabelProvider labelProvider = (DefineDataLabelProvider)DefineSubPage.this.defineElementsTableViewer.getLabelProvider();
                return labelProvider.getColumnText(element, columnIndex);
            }

            public void modify(Object element, String property, Object value) {
                int columnIndex = Arrays.asList(COLUMN_NAMES).indexOf(property);
                if (element != null && element instanceof TableItem && value instanceof String) {
                    DefineSectionHandler.Definition definition = (DefineSectionHandler.Definition)((TableItem)element).getData();
                    switch (columnIndex) {
                        case 0: {
                            ConfigTreeNodeUtilities.setText((ParseTree)definition.getDefinitionName(), (String)((String)value).trim());
                            break;
                        }
                        case 1: {
                            ConfigTreeNodeUtilities.setText((ParseTree)definition.getDefinitionValue(), (String)((String)value).trim());
                            break;
                        }
                    }
                    DefineSubPage.this.defineElementsTableViewer.refresh((Object)definition);
                    DefineSubPage.this.editor.setDirty();
                }
            }
        });
        this.defineElementsTableViewer.addDragSupport(3, new Transfer[]{DefineItemTransfer.getInstance()}, (DragSourceListener)new DefineSectionDragSourceListener(this, this.defineElementsTableViewer));
        this.defineElementsTableViewer.addDropSupport(19, new Transfer[]{DefineItemTransfer.getInstance()}, (DropTargetListener)new DefineSectionDropTargetListener(this.defineElementsTableViewer, this.editor));
        this.internalRefresh();
    }

    private void internalRefresh() {
        this.add.setEnabled(this.defineSectionHandler != null);
        this.remove.setEnabled(this.defineSectionHandler != null);
        this.defineElementsTable.setEnabled(this.defineSectionHandler != null);
        this.defineElementsTableViewer.setInput((Object)this.defineSectionHandler);
        if (this.defineSectionHandler != null) {
            this.totalDefineElementsLabel.setText("Total: " + this.defineSectionHandler.getDefinitions().size());
        }
    }

    public void refreshData(DefineSectionHandler defineSectionHandler) {
        this.defineSectionHandler = defineSectionHandler;
        if (this.defineElementsTableViewer != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DefineSubPage.this.internalRefresh();
                }
            });
        }
    }

    private void createNewDefineSection() {
        if (this.defineSectionHandler == null) {
            return;
        }
        ParserRuleContext sectionRoot = new ParserRuleContext();
        this.defineSectionHandler.setLastSectionRoot(sectionRoot);
        AddedParseTree header = new AddedParseTree("\n[DEFINE]");
        ConfigTreeNodeUtilities.addChild((ParseTree)sectionRoot, (ParseTree)header);
        ParserRuleContext root = this.editor.getParseTreeRoot();
        if (root != null) {
            root.addChild((RuleContext)sectionRoot);
        }
    }

    private DefineSectionHandler.Definition createNewDefineItem() {
        if (this.defineSectionHandler == null) {
            return null;
        }
        DefineSectionHandler.Definition item = new DefineSectionHandler.Definition();
        ParserRuleContext root = new ParserRuleContext();
        item.setRoot((ParseTree)root);
        AddedParseTree name = new AddedParseTree("definition_name");
        AddedParseTree value = new AddedParseTree("definition_value");
        item.setDefinitionName((ParseTree)name);
        item.setDefinitionValue((ParseTree)value);
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)ConfigTreeNodeUtilities.createHiddenTokenNode((String)"\n"));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)name);
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree(" := "));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)value);
        return item;
    }

    private void removeDefineSection() {
        if (this.defineSectionHandler == null || this.defineSectionHandler.getLastSectionRoot() == null) {
            return;
        }
        ConfigTreeNodeUtilities.removeChild((ParseTree)this.editor.getParseTreeRoot(), (ParseTree)this.defineSectionHandler.getLastSectionRoot());
        this.defineSectionHandler.setLastSectionRoot((ParserRuleContext)null);
    }

    public void removeSelectedDefineItems() {
        if (this.defineSectionHandler == null || this.defineElementsTableViewer == null) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)this.defineElementsTableViewer.getSelection();
        for (DefineSectionHandler.Definition item : selection) {
            if (item == null) continue;
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.defineSectionHandler.getLastSectionRoot(), (ParseTree)item.getRoot());
            this.defineSectionHandler.getDefinitions().remove(item);
        }
    }
}

