/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.tuple.Triple;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;

public final class CodeMiningMaps {
    private static Map<String, IntObjectHashMap<Triple<String, Image, Object>>> contentCodeMinings = new HashMap<String, IntObjectHashMap<Triple<String, Image, Object>>>();
    private static Map<String, IntObjectHashMap<Triple<String, Image, Object>>> headerCodeMinings = new HashMap<String, IntObjectHashMap<Triple<String, Image, Object>>>();

    private static synchronized IntObjectHashMap<Triple<String, Image, Object>> getCodeMiningMap(CodeMiningType type, String key) {
        IntObjectHashMap<Triple<String, Image, Object>> existing;
        IntObjectHashMap<Triple<String, Image, Object>> intObjectHashMap = existing = type == CodeMiningType.Header ? headerCodeMinings.get(key) : contentCodeMinings.get(key);
        if (existing != null) {
            return existing;
        }
        IntObjectHashMap newmap = new IntObjectHashMap();
        if (type == CodeMiningType.Header) {
            headerCodeMinings.put(key, (IntObjectHashMap<Triple<String, Image, Object>>)newmap);
        } else {
            contentCodeMinings.put(key, (IntObjectHashMap<Triple<String, Image, Object>>)newmap);
        }
        return newmap;
    }

    private static synchronized void setCodeMiningMap(CodeMiningType type, String filename, IntObjectHashMap<Triple<String, Image, Object>> newmap) {
        if (type == CodeMiningType.Header) {
            headerCodeMinings.put(filename, newmap);
        } else {
            contentCodeMinings.put(filename, newmap);
        }
    }

    public static synchronized void addCodeMining(CodeMiningType type, String file, int offset, String text, Image image, Object data) {
        IntObjectHashMap<Triple<String, Image, Object>> miningMap = CodeMiningMaps.getCodeMiningMap(type, file);
        if (miningMap == null) {
            return;
        }
        miningMap.asSynchronized().put(offset, (Object)Tuples.triple((Object)text, (Object)image, (Object)data));
    }

    public static synchronized IntObjectHashMap<Triple<String, Image, Object>> getCodeMinings(CodeMiningType type, IFile file) {
        if (file == null) {
            return null;
        }
        return CodeMiningMaps.getCodeMiningMap(type, file.getFullPath().toOSString());
    }

    public static synchronized void update(String filename, DocumentEvent event, int removedNL) {
        IntObjectHashMap<Triple<String, Image, Object>> existing = contentCodeMinings.get(filename);
        IntObjectHashMap tempMap = new IntObjectHashMap();
        int change = event.getText().length() - event.fLength;
        if (existing != null) {
            existing.forEachKeyValue((IntObjectProcedure & Serializable)(key, value) -> {
                if (key < event.fOffset || key > event.fOffset + event.fLength) {
                    tempMap.put(key < event.fOffset ? key : key + change, value);
                }
            });
        }
        CodeMiningMaps.setCodeMiningMap(CodeMiningType.Content, filename, (IntObjectHashMap<Triple<String, Image, Object>>)tempMap);
        long replCount = event.fText.chars().filter(ch -> ch == 10).count();
        if (event.fLength > 0) {
            replCount -= (long)removedNL;
        }
        int intCount = (int)replCount;
        existing = headerCodeMinings.get(filename);
        IntObjectHashMap tempMap2 = new IntObjectHashMap();
        if (existing != null) {
            existing.forEachKeyValue((IntObjectProcedure & Serializable)(key, value) -> {
                try {
                    if (event.fDocument.getLineOfOffset(event.fOffset) < key) {
                        tempMap.put(key + intCount, value);
                    } else {
                        tempMap.put(key, value);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            });
        }
        CodeMiningMaps.setCodeMiningMap(CodeMiningType.Header, filename, (IntObjectHashMap<Triple<String, Image, Object>>)tempMap2);
    }

    public static void removeCodeMining(CodeMiningType type, Location location) {
        if (location == NULL_Location.INSTANCE) {
            return;
        }
        String file = location.getFile().getFullPath().toOSString();
        CodeMiningMaps.removeCodeMining(type, file, location.getLine());
    }

    public static void removeCodeMining(CodeMiningType type, String key, int line) {
        IntObjectHashMap<Triple<String, Image, Object>> miningMap = CodeMiningMaps.getCodeMiningMap(type, key);
        if (miningMap == null) {
            return;
        }
        miningMap.asSynchronized().remove(line);
    }

    public static enum CodeMiningType {
        Header,
        Content,
        LineEnd;

    }
}

