/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.LazyFuzzyParamData;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Template_ActualParameter
extends ActualParameter {
    private final TemplateInstance template;
    private TemplateRestriction.Restriction_type genRestrictionCheck = TemplateRestriction.Restriction_type.TR_NONE;

    public Template_ActualParameter(TemplateInstance template) {
        this.template = template;
    }

    public TemplateInstance getTemplateInstance() {
        return this.template;
    }

    public void setGenRestrictionCheck(TemplateRestriction.Restriction_type tr) {
        this.genRestrictionCheck = tr;
    }

    public TemplateRestriction.Restriction_type getGenRestrictionCheck() {
        return this.genRestrictionCheck;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.template != null) {
            this.template.setMyScope(scope);
        }
    }

    @Override
    public boolean hasSingleExpression(FormalParameter formalParameter) {
        if (this.genRestrictionCheck != TemplateRestriction.Restriction_type.TR_NONE) {
            return true;
        }
        if (this.template != null) {
            return this.template.hasSingleExpression();
        }
        return false;
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.template != null) {
            this.template.setCodeSection(codeSection);
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        ActualParameterList parameterList;
        ISubReference subReference;
        if (this.template == null) {
            return;
        }
        Reference derivedReference = this.template.getDerivedReference();
        if (derivedReference != null && (subReference = derivedReference.getSubreferences().get(0)) instanceof ParameterisedSubReference && (parameterList = ((ParameterisedSubReference)subReference).getActualParameters()) != null) {
            parameterList.checkRecursions(timestamp, referenceChain);
        }
        referenceChain.markState();
        this.template.getTemplateBody().checkRecursions(timestamp, referenceChain);
        referenceChain.previousState();
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.template != null) {
            this.template.updateSyntax(reparser, false);
            reparser.updateLocation(this.template.getLocation());
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.template == null || this.template.accept(v);
    }

    @Override
    public void generateCodeDefaultValue(JavaGenData aData, StringBuilder source) {
        if (this.template == null) {
            return;
        }
        TTCN3Template temp = this.template.getTemplateBody();
        Reference baseReference = this.template.getDerivedReference();
        if (baseReference != null) {
            ExpressionStruct expression = new ExpressionStruct();
            expression.expression.append(MessageFormat.format("{0}.operator_assign(", temp.get_lhs_name()));
            baseReference.generateCode(aData, expression);
            expression.expression.append(')');
        }
    }

    @Override
    public void generateCode(JavaGenData aData, ExpressionStruct expression, FormalParameter formalParameter) {
        if (this.template != null) {
            FormalParameter.parameterEvaluationType eval;
            FormalParameter.parameterEvaluationType parameterEvaluationType2 = eval = formalParameter == null ? FormalParameter.parameterEvaluationType.NORMAL_EVAL : formalParameter.getEvaluationType();
            if (eval == FormalParameter.parameterEvaluationType.NORMAL_EVAL) {
                StringBuilder expressionExpression = new StringBuilder();
                ExpressionStruct tempExpression = new ExpressionStruct();
                this.template.generateCode(aData, tempExpression, this.genRestrictionCheck);
                if (tempExpression.preamble.length() > 0) {
                    expression.preamble.append((CharSequence)tempExpression.preamble);
                }
                if (tempExpression.postamble.length() == 0) {
                    expressionExpression.append((CharSequence)tempExpression.expression);
                } else {
                    String tempId = aData.getTemporaryVariableName();
                    this.template.getTemplateBody().getMyGovernor().getGenNameTemplate(aData, expression.preamble);
                    expression.preamble.append(" ");
                    expression.preamble.append(tempId);
                    expression.preamble.append("(");
                    expression.preamble.append((CharSequence)tempExpression.expression);
                    expression.preamble.append(")");
                    expression.preamble.append((CharSequence)tempExpression.postamble);
                    expressionExpression.append(tempId);
                }
                expression.expression.append((CharSequence)expressionExpression);
            } else {
                boolean used_as_lvalue = formalParameter == null ? false : formalParameter.getUsedAsLvalue();
                LazyFuzzyParamData.init(used_as_lvalue);
                LazyFuzzyParamData.generateCode(aData, expression, this.template, this.genRestrictionCheck, eval == FormalParameter.parameterEvaluationType.LAZY_EVAL);
                LazyFuzzyParamData.clean();
            }
        }
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.template != null) {
            this.template.reArrangeInitCode(aData, source, usageModule);
        }
    }
}

