/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Port;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.PortGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Check_Port_Statement
extends Statement {
    private static final String NOINCOMINGQUEUE = "Port type `{0}'' does not have incoming queue because it has neither incoming messages nor incoming or outgoing signatues";
    private static final String FULLNAMEPART1 = ".portreference";
    private static final String FULLNAMEPART2 = ".from";
    private static final String FULLNAMEPART3 = ".redirectSender";
    private static final String FULLNAMEPART4 = ".redirectIndex";
    private static final String FULLNAMEPART5 = ".redirectTimestamp";
    private static final String STATEMENT_NAME = "check";
    private final Reference portReference;
    private final boolean anyFrom;
    private final TemplateInstance fromClause;
    private final Reference redirectSender;
    private final Reference redirectIndex;
    private final Reference redirectTimestamp;

    public Check_Port_Statement(Reference portReference, boolean anyFrom, TemplateInstance fromClause, Reference redirectSender, Reference redirectIndex, Reference redirectTimestamp) {
        this.portReference = portReference;
        this.anyFrom = anyFrom;
        this.fromClause = fromClause;
        this.redirectSender = redirectSender;
        this.redirectIndex = redirectIndex;
        this.redirectTimestamp = redirectTimestamp;
        if (portReference != null) {
            portReference.setFullNameParent(this);
        }
        if (fromClause != null) {
            fromClause.setFullNameParent(this);
        }
        if (redirectSender != null) {
            redirectSender.setFullNameParent(this);
        }
        if (redirectIndex != null) {
            redirectIndex.setFullNameParent(this);
        }
        if (redirectTimestamp != null) {
            redirectTimestamp.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_CHECK;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.fromClause == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.redirectSender == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.redirectIndex == child) {
            return builder.append(FULLNAMEPART4);
        }
        if (this.redirectTimestamp == child) {
            return builder.append(FULLNAMEPART5);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.portReference != null) {
            this.portReference.setMyScope(scope);
        }
        if (this.fromClause != null) {
            this.fromClause.setMyScope(scope);
        }
        if (this.redirectSender != null) {
            this.redirectSender.setMyScope(scope);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setMyScope(scope);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.portReference != null) {
            this.portReference.setCodeSection(codeSection);
        }
        if (this.fromClause != null) {
            this.fromClause.setCodeSection(codeSection);
        }
        if (this.redirectSender != null) {
            this.redirectSender.setCodeSection(codeSection);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setCodeSection(codeSection);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setCodeSection(codeSection);
        }
    }

    @Override
    public boolean hasReceivingStatement() {
        return true;
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        Port_Type portType = Port_Utility.checkPortReference(timestamp, this, this.portReference, this.anyFrom);
        if (portType != null && !portType.getPortBody().hasQueue(timestamp)) {
            this.portReference.getLocation().reportSemanticError(MessageFormat.format(NOINCOMINGQUEUE, portType.getTypename()));
        }
        Port_Utility.checkFromClause(timestamp, this, portType, this.fromClause, this.redirectSender);
        if (this.redirectIndex != null && this.portReference != null) {
            Assignment assignment = this.portReference.getRefdAssignment(timestamp, false);
            Check_Port_Statement.checkIndexRedirection(timestamp, this.redirectIndex, assignment == null ? null : ((Def_Port)assignment).getDimensions(), this.anyFrom, "port");
        }
        Port_Utility.checkTimestampRedirect(timestamp, portType, this.redirectTimestamp);
        if (this.redirectSender != null) {
            this.redirectSender.setUsedOnLeftHandSide();
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setUsedOnLeftHandSide();
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setUsedOnLeftHandSide();
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.redirectSender != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(253);
        if (this.fromClause != null) {
            return result;
        }
        result.add(62);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.portReference != null) {
            this.portReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference.getLocation());
        }
        if (this.fromClause != null) {
            this.fromClause.updateSyntax(reparser, false);
            reparser.updateLocation(this.fromClause.getLocation());
        }
        if (this.redirectSender != null) {
            this.redirectSender.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectSender.getLocation());
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectIndex.getLocation());
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectTimestamp.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.portReference != null) {
            this.portReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.fromClause != null) {
            this.fromClause.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectSender != null) {
            this.redirectSender.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.portReference != null && !this.portReference.accept(v)) {
            return false;
        }
        if (this.fromClause != null && !this.fromClause.accept(v)) {
            return false;
        }
        if (this.redirectSender != null && !this.redirectSender.accept(v)) {
            return false;
        }
        if (this.redirectIndex != null && !this.redirectIndex.accept(v)) {
            return false;
        }
        return this.redirectTimestamp == null || this.redirectTimestamp.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        this.generateCodeExpression(aData, expression, null);
        source.append((CharSequence)expression.preamble);
        PortGenerator.generateCodeStandalone(aData, source, expression.expression.toString(), this.getStatementName(), this.canRepeat(), this.getLocation());
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, String callTimer) {
        if (this.portReference != null) {
            this.portReference.generateCode(aData, expression);
            expression.expression.append(".check");
        } else {
            aData.addBuiltinTypeImport("TitanPort");
            expression.expression.append("TitanPort.any_check");
        }
        expression.expression.append('(');
        this.generateCodeExprFromclause(aData, expression);
        expression.expression.append(", ");
        if (this.redirectSender == null) {
            expression.expression.append("null");
        } else {
            this.redirectSender.generateCode(aData, expression);
        }
        expression.expression.append(", ");
        if (this.redirectTimestamp == null) {
            expression.expression.append("null");
        } else {
            this.redirectTimestamp.generateCode(aData, expression);
        }
        if (this.portReference != null) {
            expression.expression.append(",");
            if (this.redirectIndex == null) {
                expression.expression.append("null");
            } else {
                Check_Port_Statement.generateCodeIndexRedirect(aData, expression, this.redirectIndex, this.getMyScope());
            }
        }
        expression.expression.append(')');
    }

    private void generateCodeExprFromclause(JavaGenData aData, ExpressionStruct expression) {
        if (this.fromClause != null) {
            this.fromClause.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE);
        } else if (this.redirectSender != null) {
            IType varType = this.redirectSender.checkVariableReference(CompilationTimeStamp.getBaseTimestamp());
            if (varType == null) {
                ErrorReporter.INTERNAL_ERROR((String)("Encountered a redirection with unknown type `" + this.getFullName() + "''"));
            }
            if (varType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetype() == IType.Type_type.TYPE_COMPONENT) {
                aData.addBuiltinTypeImport("TitanComponent_template");
                expression.expression.append("TitanComponent_template.any_compref");
            } else {
                expression.expression.append(MessageFormat.format("new {0}(template_sel.ANY_VALUE)", varType.getGenNameTemplate(aData, expression.expression)));
            }
        } else {
            aData.addBuiltinTypeImport("TitanComponent_template");
            expression.expression.append("TitanComponent_template.any_compref");
        }
    }
}

