/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.types.ComponentTypeList;
import org.eclipse.titan.designer.AST.ASN1.types.ExtensionAddition;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ExtensionAdditionGroup
extends ExtensionAddition {
    private final Value versionNumber;
    private final ComponentTypeList componentTypes;

    public ExtensionAdditionGroup(Value versionNumber, ComponentTypeList componentTypes) {
        this.versionNumber = versionNumber;
        this.componentTypes = componentTypes;
        if (null != versionNumber) {
            versionNumber.setFullNameParent(this);
        }
        componentTypes.setFullNameParent(this);
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.versionNumber == child) {
            builder.append(".<versionnumber>");
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.versionNumber) {
            this.versionNumber.setMyScope(scope);
        }
        this.componentTypes.setMyScope(scope);
    }

    @Override
    public int getNofComps() {
        return this.componentTypes.getNofComps();
    }

    @Override
    public CompField getCompByIndex(int index) {
        return this.componentTypes.getCompByIndex(index);
    }

    @Override
    public boolean hasCompWithName(Identifier identifier) {
        return this.componentTypes.hasCompWithName(identifier);
    }

    @Override
    public CompField getCompByName(Identifier identifier) {
        return this.componentTypes.getCompByName(identifier);
    }

    @Override
    public void trCompsof(CompilationTimeStamp timestamp, IReferenceChain referenceChain, boolean isSet) {
        this.componentTypes.trCompsof(timestamp, referenceChain, isSet);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.versionNumber != null) {
            this.versionNumber.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.componentTypes != null) {
            this.componentTypes.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.versionNumber != null && !this.versionNumber.accept(v)) {
            return false;
        }
        return this.componentTypes == null || this.componentTypes.accept(v);
    }
}

