/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1;

import java.lang.ref.WeakReference;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.parsers.asn1parser.TokenWithIndexAndSubTokens;

public final class Block
implements INamedNode,
IVisitableNode,
Token,
TokenSource {
    private Location mLocation;
    private WeakReference<INamedNode> mNameParent;
    private List<Token> tokenList;
    private int index = 0;
    private TokenFactory<?> _factory = CommonTokenFactory.DEFAULT;

    private Block(Location aLocation) {
        this.mLocation = aLocation;
    }

    public Block(List<Token> tokenList, Location location) {
        this(location);
        this.tokenList = tokenList;
    }

    public Block(Token token) {
        if (token instanceof TokenWithIndexAndSubTokens) {
            this.tokenList = ((TokenWithIndexAndSubTokens)token).getSubTokens();
            IFile sourceFile = ((TokenWithIndexAndSubTokens)token).getSourceFile();
            this.setLocation(new Location((IResource)sourceFile, token.getLine(), token.getStartIndex(), token.getStopIndex()));
        } else {
            this.setLocation(NULL_Location.INSTANCE);
            this.tokenList = ((TokenWithIndexAndSubTokens)token).getSubTokens();
        }
    }

    public Location getLocation() {
        return this.mLocation;
    }

    public void setLocation(Location aLocation) {
        this.mLocation = aLocation;
    }

    @Override
    public String getFullName() {
        return this.getFullName(null).toString();
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        INamedNode tempParent;
        if (null != this.mNameParent && null != (tempParent = (INamedNode)this.mNameParent.get())) {
            return tempParent.getFullName(this);
        }
        return new StringBuilder();
    }

    @Override
    public void setFullNameParent(INamedNode nameParent) {
        this.mNameParent = new WeakReference<INamedNode>(nameParent);
    }

    @Override
    public INamedNode getNameParent() {
        return (INamedNode)this.mNameParent.get();
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return v.leave(this) != 2;
    }

    public int getTokenListSize() {
        return this.tokenList.size();
    }

    public List<Token> getTokenList() {
        return this.tokenList;
    }

    public int getCharPositionInLine() {
        return this.tokenList.get(0).getCharPositionInLine();
    }

    public CharStream getInputStream() {
        assert (false);
        return null;
    }

    public int getLine() {
        return this.tokenList.get(0).getLine();
    }

    public int getChannel() {
        return 0;
    }

    public int getStartIndex() {
        return this.tokenList.get(0).getStartIndex();
    }

    public int getStopIndex() {
        return this.tokenList.get(this.tokenList.size() - 1).getStopIndex();
    }

    public String getText() {
        StringBuilder text = new StringBuilder();
        for (Token t : this.tokenList) {
            text.append(t.getText());
        }
        return text.toString();
    }

    public int getTokenIndex() {
        assert (false);
        return -1;
    }

    public TokenSource getTokenSource() {
        assert (false);
        return null;
    }

    public int getType() {
        return 1;
    }

    public String getSourceName() {
        return "<unknown>";
    }

    public TokenFactory<?> getTokenFactory() {
        return this._factory;
    }

    public Token nextToken() {
        return this.tokenList.get(this.index++);
    }

    public void setTokenFactory(TokenFactory<?> factory) {
        this._factory = factory;
    }
}

