/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.parsers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.ConsolePrinter;
import org.eclipse.titan.common.parsers.IPrinter;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.common.parsers.cfg.CfgInterval;

public final class ParserLogger {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IPrinter sPrinter = new ConsolePrinter();

    private ParserLogger() {
    }

    private static void setPrinter(IPrinter aPrinter) {
        sPrinter = aPrinter;
    }

    public static synchronized void log(ParseTree aRoot, Parser aParser, IPrinter aPrinter, String aDescription) {
        if (!aParser.getBuildParseTree()) {
            return;
        }
        ParserLogger.setPrinter(aPrinter);
        aPrinter.println("---- parse tree");
        aPrinter.println(DATE_FORMAT.format(new Date()));
        aPrinter.println("Parser type: " + aDescription + ", Prediction mode: " + ((ParserATNSimulator)aParser.getInterpreter()).getPredictionMode());
        aPrinter.println("Call stack: " + ParserLogger.printCallStackReverse(4));
        TokenStream tokenStream = aParser.getTokenStream();
        if (!(tokenStream instanceof CommonTokenStream)) {
            aPrinter.println("ERROR: tokenStream is not CommonTokenStream");
            return;
        }
        CommonTokenStream commonTokenStream = (CommonTokenStream)tokenStream;
        List tokens = commonTokenStream.getTokens();
        ParserLogger.log(aRoot, aParser, tokens);
    }

    public static void log(ParseTree aRoot, Parser aParser, List<Token> aTokens) {
        try {
            ParserLogger.log(aRoot, aParser, aTokens, new ArrayList<Boolean>(), false, false);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            ParserLogger.println(sw.toString());
        }
    }

    private static void log(ParseTree aRoot, Parser aParser, List<Token> aTokens, List<Boolean> aLevel, boolean aParentOneChild, boolean aLastChild) {
        if (aRoot == null) {
            ParserLogger.println("ERROR: ParseTree root is null");
            return;
        }
        if (!aParser.getBuildParseTree()) {
            ParserLogger.println("ERROR: ParseTree is not build. Call Parser.setBuildParseTree( true ); BEFORE parsing. Or do NOT call Parser.setBuildParseTree( false );");
            return;
        }
        if (aRoot instanceof ParserRuleContext) {
            boolean oneChild;
            ParserRuleContext rule = (ParserRuleContext)aRoot;
            String ruleInfo = ParserLogger.getRuleInfo(rule, aParser);
            if (aParentOneChild) {
                ParserLogger.printArrow(ruleInfo);
            } else {
                ParserLogger.printIndent(ruleInfo, aLevel);
            }
            int count = rule.getChildCount();
            boolean bl = oneChild = count == 1 && rule.exception == null;
            if (!oneChild) {
                ParserLogger.println(": '" + ParserLogger.getEscapedRuleText(rule, aTokens) + "'" + ParserLogger.getExceptionInfo(rule, aParser));
            }
            for (int i = 0; i < count; ++i) {
                ParseTree child = rule.getChild(i);
                List<Boolean> level = aLevel;
                if (!aParentOneChild) {
                    level = new ArrayList<Boolean>(aLevel);
                    if (aLastChild) {
                        level.set(level.size() - 1, false);
                    }
                    level.add(true);
                }
                ParserLogger.log(child, aParser, aTokens, level, oneChild, i == count - 1);
            }
        } else if (aRoot instanceof TerminalNodeImpl) {
            TerminalNodeImpl tn = (TerminalNodeImpl)aRoot;
            if (aParentOneChild) {
                ParserLogger.println(": '" + ParserLogger.getEscapedTokenText(tn.getSymbol()) + "'");
            }
            ParserLogger.printIndent(ParserLogger.getTokenInfo(tn.getSymbol(), aParser), aLevel);
            if (tn.parent == null) {
                ParserLogger.print(", parent == null <-------------------------------------------------------------- ERROR");
            }
            ParserLogger.println();
        } else if (aRoot instanceof AddedParseTree) {
            AddedParseTree apt = (AddedParseTree)aRoot;
            if (aParentOneChild) {
                ParserLogger.println(": '" + ParserLogger.getEscapedText(apt.getText()) + "'");
            }
            ParserLogger.printIndent("AddedParseString: " + ParserLogger.getEscapedText(apt.getText()), aLevel);
            if (apt.getParent() == null) {
                ParserLogger.print(", parent == null <-------------------------------------------------------------- ERROR");
            }
            ParserLogger.println();
        } else {
            ParserLogger.println("ERROR: INVALID ParseTree type");
        }
    }

    private static String getExceptionInfo(ParserRuleContext aRule, Parser aParser) {
        RecognitionException e = aRule.exception;
        if (e == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(", ERROR: mismatch, expected tokens: [");
        List expectedTokens = e.getExpectedTokens().toList();
        for (int i = 0; i < expectedTokens.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            int tokenType = (Integer)expectedTokens.get(i);
            sb.append(ParserLogger.getTokenName(tokenType, aParser));
        }
        sb.append(']');
        if (e instanceof NoViableAltException) {
            NoViableAltException nvae = (NoViableAltException)e;
            sb.append(", start token: " + ParserLogger.getTokenInfo(nvae.getStartToken(), aParser));
        }
        return sb.toString();
    }

    private static String getRuleInfo(ParserRuleContext aRule, Parser aParser) {
        String info = (String)aParser.getRuleInvocationStack((RuleContext)aRule).get(0);
        return info;
    }

    private static String getEscapedRuleText(ParserRuleContext aRule, List<Token> aTokens) {
        Token startToken = aRule.start;
        if (startToken == null) {
            ParserLogger.println("ERROR: ParseLogger.getEscapedRuleText() startToken == null");
            return "";
        }
        Token stopToken = aRule.stop;
        if (stopToken == null) {
            ParserLogger.println("ERROR: ParseLogger.getEscapedRuleText() stopToken == null");
            return "";
        }
        int startIndex = startToken.getTokenIndex();
        int stopIndex = stopToken.getTokenIndex();
        StringBuilder sb = new StringBuilder();
        for (int i = startIndex; i <= stopIndex; ++i) {
            try {
                sb.append(ParserLogger.getEscapedTokenText(aTokens.get(i)));
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                sb.append('_');
            }
        }
        return sb.toString();
    }

    public static String getRuleText(ParserRuleContext aRule, List<Token> aTokens) {
        Token startToken = aRule.start;
        if (startToken == null) {
            ParserLogger.println("ERROR: ParseLogger.getEscapedRuleText() startToken == null");
            return "";
        }
        Token stopToken = aRule.stop;
        if (stopToken == null) {
            ParserLogger.println("ERROR: ParseLogger.getEscapedRuleText() stopToken == null");
            return "";
        }
        int startIndex = startToken.getTokenIndex();
        int stopIndex = stopToken.getTokenIndex();
        StringBuilder sb = new StringBuilder();
        for (int i = startIndex; i <= stopIndex; ++i) {
            sb.append(aTokens.get(i));
        }
        return sb.toString();
    }

    private static String getTokenInfo(Token aToken, Parser aParser) {
        StringBuilder sb = new StringBuilder();
        int tokenType = aToken.getType();
        String tokenName = ParserLogger.getTokenName(tokenType, aParser);
        sb.append(tokenName);
        sb.append(": ");
        sb.append('\'');
        sb.append(ParserLogger.getEscapedTokenText(aToken));
        sb.append('\'');
        sb.append(", @" + aToken.getTokenIndex());
        sb.append(", " + aToken.getLine() + ":" + aToken.getCharPositionInLine());
        if (aToken.getChannel() > 0) {
            sb.append(", channel=");
            sb.append(aToken.getChannel());
        }
        return sb.toString();
    }

    private static String getEscapedTokenText(Token aToken) {
        return ParserLogger.getEscapedText(aToken.getText());
    }

    public static String getEscapedText(String aText) {
        String txt = aText;
        if (txt == null) {
            return "";
        }
        txt = txt.replace("\n", "\\n");
        txt = txt.replace("\r", "\\r");
        txt = txt.replace("\t", "\\t");
        return txt;
    }

    private static String getTokenName(int aTokenType, Parser aParser) {
        Vocabulary vocabulary = aParser.getVocabulary();
        String symbolicName = vocabulary.getSymbolicName(aTokenType);
        return symbolicName;
    }

    public static void logInterval(Interval aRootInterval) {
        ParserLogger.logInterval(aRootInterval, 0);
    }

    private static void logInterval(Interval aRootInterval, int aLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append("" + aRootInterval.getDepth());
        sb.append(", " + aRootInterval.getStartOffset());
        sb.append(", " + aRootInterval.getStartLine());
        sb.append(", " + aRootInterval.getEndOffset());
        sb.append(", " + aRootInterval.getEndLine());
        sb.append(", " + (Object)((Object)aRootInterval.getType()));
        if (aRootInterval instanceof CfgInterval) {
            sb.append(", " + (Object)((Object)((CfgInterval)aRootInterval).getSectionType()));
        }
        if (aRootInterval.getErroneous()) {
            sb.append(", ERRONEOUS");
        }
        ParserLogger.printIndent(sb.toString(), aLevel);
        ParserLogger.println();
        if (aRootInterval.getSubIntervals() != null) {
            for (Interval interval : aRootInterval.getSubIntervals()) {
                ParserLogger.logInterval(interval, aLevel + 1);
            }
        }
    }

    private static void printArrow(String aMsg) {
        ParserLogger.print(" -> ");
        ParserLogger.print(aMsg);
    }

    private static void printIndent(String aMsg, int aLevel) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < aLevel; ++i) {
            sb.append("  ");
        }
        ParserLogger.print(sb.toString());
        ParserLogger.print(aMsg);
    }

    private static void printIndent(String aMsg, List<Boolean> aLevel) {
        StringBuilder sb = new StringBuilder();
        int size = aLevel.size();
        for (int i = 0; i < size; ++i) {
            if (i < size - 1) {
                sb.append(aLevel.get(i) != false ? "| " : "  ");
                continue;
            }
            sb.append("+-");
        }
        ParserLogger.print(sb.toString());
        ParserLogger.print(aMsg);
    }

    public static String printCallStack(int aN) {
        int first;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (int i = first = stackTrace.length - 1; i >= aN; --i) {
            StackTraceElement ste = stackTrace[i];
            if (i < first) {
                sb.append(" -> ");
            }
            ParserLogger.printStackTraceElement(sb, ste);
        }
        return sb.toString();
    }

    public static String printCallStackReverse(int aN) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (int i = aN; i < stackTrace.length; ++i) {
            StackTraceElement ste = stackTrace[i];
            if (i > aN) {
                sb.append(" <- ");
            }
            ParserLogger.printStackTraceElement(sb, ste);
        }
        return sb.toString();
    }

    private static void printStackTraceElement(StringBuilder aSb, StackTraceElement aSte) {
        String className = aSte.getClassName();
        String shortClassName = className.substring(className.lastIndexOf(46) + 1);
        aSb.append(shortClassName);
        aSb.append('.');
        aSb.append(aSte.getMethodName());
        aSb.append(':');
        aSb.append(aSte.getLineNumber());
    }

    private static void print(String aMsg) {
        sPrinter.print(aMsg);
    }

    private static void println() {
        sPrinter.println();
    }

    private static void println(String aMsg) {
        sPrinter.println(aMsg);
    }
}

