/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.utils;

import org.eclipse.iot.tiaki.domain.Fqdn;

public final class FormattingUtil {
    private static final String QUERY_OUTPUT = ";; QUERY\n%s %s";
    private static final String SIMPLE_RESPONSE_OUTPUT = "%s";
    private static final String RESPONSE_OUTPUT = ";; RESPONSE\n%s\n";
    private static final String SERVER_OUTPUT = ";; SERVER\n%s\n";
    private static final String ANSWER_OUTPUT = ";; ANSWER";
    private static final String INFO_OUTPUT = ";; INFO\n%s\n";

    public static String answer() {
        return ANSWER_OUTPUT;
    }

    public static String info(String what) {
        return String.format(INFO_OUTPUT, what);
    }

    public static String server(String server) {
        return String.format(SERVER_OUTPUT, server);
    }

    public static String query(Fqdn name, String prefix, String type) {
        return String.format(QUERY_OUTPUT, name.fqdnWithPrefix(prefix), type);
    }

    public static String simpleResponse(String content) {
        return String.format(SIMPLE_RESPONSE_OUTPUT, content);
    }

    public static String response(String content) {
        return String.format(RESPONSE_OUTPUT, content);
    }

    public static String unableToResolve(String what) {
        return String.format("Unable to resolve [%s]", what);
    }

    public static String unableToValidate(String what) {
        return String.format("Unable to authenticate [%s]: network/server error", what);
    }

    public static String authenticData(String which) {
        return String.format("Received authentic data for [%s]", which);
    }

    public static String networkError(String what) {
        return String.format("Experienced a network errror [%s]", what);
    }

    public static String unableToRetrieveLabel(String forWhat) {
        return String.format("Unable to retrieve the DNS label [%s]", forWhat);
    }

    private FormattingUtil() {
        throw new AssertionError((Object)String.format("No instances of %s for you!", this.getClass().getName()));
    }
}

