/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.iot.tiaki.commons.StatusCode;
import org.eclipse.iot.tiaki.exceptions.LookupException;

public final class ExceptionsUtil {
    private static final String DATET_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static LookupException build(StatusCode error, String message, Map<String, StatusCode> trace) {
        LookupException exception = new LookupException(error, message);
        exception.setErrorsTrace(new HashMap<String, StatusCode>(trace));
        return exception;
    }

    public static String traceKey(Object who, String forWhich, String where) {
        StringBuilder builder = new StringBuilder();
        builder.append(FORMATTER.format(new Date(System.currentTimeMillis()))).append(":<").append(who.getClass().getSimpleName()).append(">:[").append(forWhich.replace(who.getClass().getName() + "@", "")).append("]@<").append(where).append(">");
        return builder.toString();
    }

    public static boolean onlyNameResolutionTrace(Map<String, StatusCode> trace) {
        int cntr = 0;
        for (StatusCode status : trace.values()) {
            if (!status.equals((Object)StatusCode.RESOLUTION_NAME_ERROR) && !status.equals((Object)StatusCode.RESOLUTION_RR_TYPE_ERROR)) continue;
            ++cntr;
        }
        return cntr == trace.size();
    }

    private ExceptionsUtil() {
        throw new AssertionError((Object)String.format("No instances of %s for you!", this.getClass().getName()));
    }
}

